package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SelfSubjectRulesReviewSpecFluent<A extends SelfSubjectRulesReviewSpecFluent<A>> extends BaseFluent<A>{
  public SelfSubjectRulesReviewSpecFluent() {
  }
  
  public SelfSubjectRulesReviewSpecFluent(SelfSubjectRulesReviewSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> scopes = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SelfSubjectRulesReviewSpec instance) {
    instance = (instance != null ? instance : new SelfSubjectRulesReviewSpec());
    if (instance != null) {
          this.withScopes(instance.getScopes());
          this.withScopes(instance.getScopes());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToScopes(int index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.add(index, item);
    return (A)this;
  }
  
  public A setToScopes(int index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.set(index, item); return (A)this;
  }
  
  public A addToScopes(java.lang.String... items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  
  public A addAllToScopes(Collection<String> items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  
  public A removeFromScopes(java.lang.String... items) {
    if (this.scopes == null) return (A)this;
    for (String item : items) { this.scopes.remove(item);} return (A)this;
  }
  
  public A removeAllFromScopes(Collection<String> items) {
    if (this.scopes == null) return (A)this;
    for (String item : items) { this.scopes.remove(item);} return (A)this;
  }
  
  public List<String> getScopes() {
    return this.scopes;
  }
  
  public String getScope(int index) {
    return this.scopes.get(index);
  }
  
  public String getFirstScope() {
    return this.scopes.get(0);
  }
  
  public String getLastScope() {
    return this.scopes.get(scopes.size() - 1);
  }
  
  public String getMatchingScope(Predicate<String> predicate) {
      for (String item : scopes) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingScope(Predicate<String> predicate) {
      for (String item : scopes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withScopes(List<String> scopes) {
    if (scopes != null) {
        this.scopes = new ArrayList();
        for (String item : scopes) {
          this.addToScopes(item);
        }
    } else {
      this.scopes = null;
    }
    return (A) this;
  }
  
  public A withScopes(java.lang.String... scopes) {
    if (this.scopes != null) {this.scopes.clear(); _visitables.remove("scopes"); }
    if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
  }
  
  public boolean hasScopes() {
    return this.scopes != null && !this.scopes.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SelfSubjectRulesReviewSpecFluent that = (SelfSubjectRulesReviewSpecFluent) o;
    if (!java.util.Objects.equals(scopes, that.scopes)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(scopes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (scopes != null && !scopes.isEmpty()) { sb.append("scopes:"); sb.append(scopes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}