package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ActionFluent<A extends ActionFluent<A>> extends BaseFluent<A>{
  public ActionFluent() {
  }
  
  public ActionFluent(Action instance) {
    this.copyInstance(instance);
  }
  private Object content;
  private Boolean isNonResourceURL;
  private String namespace;
  private String path;
  private String resource;
  private String resourceAPIGroup;
  private String resourceAPIVersion;
  private String resourceName;
  private String verb;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Action instance) {
    instance = (instance != null ? instance : new Action());
    if (instance != null) {
          this.withContent(instance.getContent());
          this.withIsNonResourceURL(instance.getIsNonResourceURL());
          this.withNamespace(instance.getNamespace());
          this.withPath(instance.getPath());
          this.withResource(instance.getResource());
          this.withResourceAPIGroup(instance.getResourceAPIGroup());
          this.withResourceAPIVersion(instance.getResourceAPIVersion());
          this.withResourceName(instance.getResourceName());
          this.withVerb(instance.getVerb());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Object getContent() {
    return this.content;
  }
  
  public A withContent(Object content) {
    this.content = content;
    return (A) this;
  }
  
  public boolean hasContent() {
    return this.content != null;
  }
  
  public Boolean getIsNonResourceURL() {
    return this.isNonResourceURL;
  }
  
  public A withIsNonResourceURL(Boolean isNonResourceURL) {
    this.isNonResourceURL = isNonResourceURL;
    return (A) this;
  }
  
  public boolean hasIsNonResourceURL() {
    return this.isNonResourceURL != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace = namespace;
    return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path = path;
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public String getResource() {
    return this.resource;
  }
  
  public A withResource(String resource) {
    this.resource = resource;
    return (A) this;
  }
  
  public boolean hasResource() {
    return this.resource != null;
  }
  
  public String getResourceAPIGroup() {
    return this.resourceAPIGroup;
  }
  
  public A withResourceAPIGroup(String resourceAPIGroup) {
    this.resourceAPIGroup = resourceAPIGroup;
    return (A) this;
  }
  
  public boolean hasResourceAPIGroup() {
    return this.resourceAPIGroup != null;
  }
  
  public String getResourceAPIVersion() {
    return this.resourceAPIVersion;
  }
  
  public A withResourceAPIVersion(String resourceAPIVersion) {
    this.resourceAPIVersion = resourceAPIVersion;
    return (A) this;
  }
  
  public boolean hasResourceAPIVersion() {
    return this.resourceAPIVersion != null;
  }
  
  public String getResourceName() {
    return this.resourceName;
  }
  
  public A withResourceName(String resourceName) {
    this.resourceName = resourceName;
    return (A) this;
  }
  
  public boolean hasResourceName() {
    return this.resourceName != null;
  }
  
  public String getVerb() {
    return this.verb;
  }
  
  public A withVerb(String verb) {
    this.verb = verb;
    return (A) this;
  }
  
  public boolean hasVerb() {
    return this.verb != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ActionFluent that = (ActionFluent) o;
    if (!java.util.Objects.equals(content, that.content)) return false;
    if (!java.util.Objects.equals(isNonResourceURL, that.isNonResourceURL)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(resource, that.resource)) return false;
    if (!java.util.Objects.equals(resourceAPIGroup, that.resourceAPIGroup)) return false;
    if (!java.util.Objects.equals(resourceAPIVersion, that.resourceAPIVersion)) return false;
    if (!java.util.Objects.equals(resourceName, that.resourceName)) return false;
    if (!java.util.Objects.equals(verb, that.verb)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(content,  isNonResourceURL,  namespace,  path,  resource,  resourceAPIGroup,  resourceAPIVersion,  resourceName,  verb,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (content != null) { sb.append("content:"); sb.append(content + ","); }
    if (isNonResourceURL != null) { sb.append("isNonResourceURL:"); sb.append(isNonResourceURL + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (resourceAPIGroup != null) { sb.append("resourceAPIGroup:"); sb.append(resourceAPIGroup + ","); }
    if (resourceAPIVersion != null) { sb.append("resourceAPIVersion:"); sb.append(resourceAPIVersion + ","); }
    if (resourceName != null) { sb.append("resourceName:"); sb.append(resourceName + ","); }
    if (verb != null) { sb.append("verb:"); sb.append(verb + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withIsNonResourceURL() {
    return withIsNonResourceURL(true);
  }
  

}