package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DockerStrategyOptionsFluent<A extends DockerStrategyOptionsFluent<A>> extends BaseFluent<A>{
  public DockerStrategyOptionsFluent() {
  }
  
  public DockerStrategyOptionsFluent(DockerStrategyOptions instance) {
    this.copyInstance(instance);
  }
  private ArrayList<EnvVarBuilder> buildArgs = new ArrayList<EnvVarBuilder>();
  private Boolean noCache;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DockerStrategyOptions instance) {
    instance = (instance != null ? instance : new DockerStrategyOptions());
    if (instance != null) {
          this.withBuildArgs(instance.getBuildArgs());
          this.withNoCache(instance.getNoCache());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToBuildArgs(int index,EnvVar item) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= buildArgs.size()) { _visitables.get("buildArgs").add(builder); buildArgs.add(builder); } else { _visitables.get("buildArgs").add(index, builder); buildArgs.add(index, builder);}
    return (A)this;
  }
  
  public A setToBuildArgs(int index,EnvVar item) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= buildArgs.size()) { _visitables.get("buildArgs").add(builder); buildArgs.add(builder); } else { _visitables.get("buildArgs").set(index, builder); buildArgs.set(index, builder);}
    return (A)this;
  }
  
  public A addToBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("buildArgs").add(builder);this.buildArgs.add(builder);} return (A)this;
  }
  
  public A addAllToBuildArgs(Collection<EnvVar> items) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("buildArgs").add(builder);this.buildArgs.add(builder);} return (A)this;
  }
  
  public A removeFromBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.buildArgs == null) return (A)this;
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("buildArgs").remove(builder); this.buildArgs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromBuildArgs(Collection<EnvVar> items) {
    if (this.buildArgs == null) return (A)this;
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("buildArgs").remove(builder); this.buildArgs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromBuildArgs(Predicate<EnvVarBuilder> predicate) {
    if (buildArgs == null) return (A) this;
    final Iterator<EnvVarBuilder> each = buildArgs.iterator();
    final List visitables = _visitables.get("buildArgs");
    while (each.hasNext()) {
      EnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EnvVar> buildBuildArgs() {
    return this.buildArgs != null ? build(buildArgs) : null;
  }
  
  public EnvVar buildBuildArg(int index) {
    return this.buildArgs.get(index).build();
  }
  
  public EnvVar buildFirstBuildArg() {
    return this.buildArgs.get(0).build();
  }
  
  public EnvVar buildLastBuildArg() {
    return this.buildArgs.get(buildArgs.size() - 1).build();
  }
  
  public EnvVar buildMatchingBuildArg(Predicate<EnvVarBuilder> predicate) {
      for (EnvVarBuilder item : buildArgs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingBuildArg(Predicate<EnvVarBuilder> predicate) {
      for (EnvVarBuilder item : buildArgs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withBuildArgs(List<EnvVar> buildArgs) {
    if (this.buildArgs != null) {
      this._visitables.get("buildArgs").clear();
    }
    if (buildArgs != null) {
        this.buildArgs = new ArrayList();
        for (EnvVar item : buildArgs) {
          this.addToBuildArgs(item);
        }
    } else {
      this.buildArgs = null;
    }
    return (A) this;
  }
  
  public A withBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... buildArgs) {
    if (this.buildArgs != null) {
        this.buildArgs.clear();
        _visitables.remove("buildArgs");
    }
    if (buildArgs != null) {
      for (EnvVar item : buildArgs) {
        this.addToBuildArgs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasBuildArgs() {
    return this.buildArgs != null && !this.buildArgs.isEmpty();
  }
  
  public BuildArgsNested<A> addNewBuildArg() {
    return new BuildArgsNested(-1, null);
  }
  
  public BuildArgsNested<A> addNewBuildArgLike(EnvVar item) {
    return new BuildArgsNested(-1, item);
  }
  
  public BuildArgsNested<A> setNewBuildArgLike(int index,EnvVar item) {
    return new BuildArgsNested(index, item);
  }
  
  public BuildArgsNested<A> editBuildArg(int index) {
    if (buildArgs.size() <= index) throw new RuntimeException("Can't edit buildArgs. Index exceeds size.");
    return setNewBuildArgLike(index, buildBuildArg(index));
  }
  
  public BuildArgsNested<A> editFirstBuildArg() {
    if (buildArgs.size() == 0) throw new RuntimeException("Can't edit first buildArgs. The list is empty.");
    return setNewBuildArgLike(0, buildBuildArg(0));
  }
  
  public BuildArgsNested<A> editLastBuildArg() {
    int index = buildArgs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last buildArgs. The list is empty.");
    return setNewBuildArgLike(index, buildBuildArg(index));
  }
  
  public BuildArgsNested<A> editMatchingBuildArg(Predicate<EnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<buildArgs.size();i++) { 
    if (predicate.test(buildArgs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching buildArgs. No match found.");
    return setNewBuildArgLike(index, buildBuildArg(index));
  }
  
  public Boolean getNoCache() {
    return this.noCache;
  }
  
  public A withNoCache(Boolean noCache) {
    this.noCache = noCache;
    return (A) this;
  }
  
  public boolean hasNoCache() {
    return this.noCache != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DockerStrategyOptionsFluent that = (DockerStrategyOptionsFluent) o;
    if (!java.util.Objects.equals(buildArgs, that.buildArgs)) return false;
    if (!java.util.Objects.equals(noCache, that.noCache)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(buildArgs,  noCache,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (buildArgs != null && !buildArgs.isEmpty()) { sb.append("buildArgs:"); sb.append(buildArgs + ","); }
    if (noCache != null) { sb.append("noCache:"); sb.append(noCache + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withNoCache() {
    return withNoCache(true);
  }
  public class BuildArgsNested<N> extends EnvVarFluent<BuildArgsNested<N>> implements Nested<N>{
    BuildArgsNested(int index,EnvVar item) {
      this.index = index;
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarBuilder builder;
    int index;
    
    public N and() {
      return (N) DockerStrategyOptionsFluent.this.setToBuildArgs(index,builder.build());
    }
    
    public N endBuildArg() {
      return and();
    }
    
  
  }

}