package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GitInfoFluent<A extends GitInfoFluent<A>> extends BaseFluent<A>{
  public GitInfoFluent() {
  }
  
  public GitInfoFluent(GitInfo instance) {
    this.copyInstance(instance);
  }
  private SourceControlUserBuilder author;
  private String commit;
  private SourceControlUserBuilder committer;
  private String httpProxy;
  private String httpsProxy;
  private String message;
  private String noProxy;
  private String ref;
  private ArrayList<GitRefInfoBuilder> refs = new ArrayList<GitRefInfoBuilder>();
  private String uri;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GitInfo instance) {
    instance = (instance != null ? instance : new GitInfo());
    if (instance != null) {
          this.withAuthor(instance.getAuthor());
          this.withCommit(instance.getCommit());
          this.withCommitter(instance.getCommitter());
          this.withHttpProxy(instance.getHttpProxy());
          this.withHttpsProxy(instance.getHttpsProxy());
          this.withMessage(instance.getMessage());
          this.withNoProxy(instance.getNoProxy());
          this.withRef(instance.getRef());
          this.withRefs(instance.getRefs());
          this.withUri(instance.getUri());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SourceControlUser buildAuthor() {
    return this.author != null ? this.author.build() : null;
  }
  
  public A withAuthor(SourceControlUser author) {
    this._visitables.remove("author");
    if (author != null) {
        this.author = new SourceControlUserBuilder(author);
        this._visitables.get("author").add(this.author);
    } else {
        this.author = null;
        this._visitables.get("author").remove(this.author);
    }
    return (A) this;
  }
  
  public boolean hasAuthor() {
    return this.author != null;
  }
  
  public A withNewAuthor(String email,String name) {
    return (A)withAuthor(new SourceControlUser(email, name));
  }
  
  public AuthorNested<A> withNewAuthor() {
    return new AuthorNested(null);
  }
  
  public AuthorNested<A> withNewAuthorLike(SourceControlUser item) {
    return new AuthorNested(item);
  }
  
  public AuthorNested<A> editAuthor() {
    return withNewAuthorLike(java.util.Optional.ofNullable(buildAuthor()).orElse(null));
  }
  
  public AuthorNested<A> editOrNewAuthor() {
    return withNewAuthorLike(java.util.Optional.ofNullable(buildAuthor()).orElse(new SourceControlUserBuilder().build()));
  }
  
  public AuthorNested<A> editOrNewAuthorLike(SourceControlUser item) {
    return withNewAuthorLike(java.util.Optional.ofNullable(buildAuthor()).orElse(item));
  }
  
  public String getCommit() {
    return this.commit;
  }
  
  public A withCommit(String commit) {
    this.commit = commit;
    return (A) this;
  }
  
  public boolean hasCommit() {
    return this.commit != null;
  }
  
  public SourceControlUser buildCommitter() {
    return this.committer != null ? this.committer.build() : null;
  }
  
  public A withCommitter(SourceControlUser committer) {
    this._visitables.remove("committer");
    if (committer != null) {
        this.committer = new SourceControlUserBuilder(committer);
        this._visitables.get("committer").add(this.committer);
    } else {
        this.committer = null;
        this._visitables.get("committer").remove(this.committer);
    }
    return (A) this;
  }
  
  public boolean hasCommitter() {
    return this.committer != null;
  }
  
  public A withNewCommitter(String email,String name) {
    return (A)withCommitter(new SourceControlUser(email, name));
  }
  
  public CommitterNested<A> withNewCommitter() {
    return new CommitterNested(null);
  }
  
  public CommitterNested<A> withNewCommitterLike(SourceControlUser item) {
    return new CommitterNested(item);
  }
  
  public CommitterNested<A> editCommitter() {
    return withNewCommitterLike(java.util.Optional.ofNullable(buildCommitter()).orElse(null));
  }
  
  public CommitterNested<A> editOrNewCommitter() {
    return withNewCommitterLike(java.util.Optional.ofNullable(buildCommitter()).orElse(new SourceControlUserBuilder().build()));
  }
  
  public CommitterNested<A> editOrNewCommitterLike(SourceControlUser item) {
    return withNewCommitterLike(java.util.Optional.ofNullable(buildCommitter()).orElse(item));
  }
  
  public String getHttpProxy() {
    return this.httpProxy;
  }
  
  public A withHttpProxy(String httpProxy) {
    this.httpProxy = httpProxy;
    return (A) this;
  }
  
  public boolean hasHttpProxy() {
    return this.httpProxy != null;
  }
  
  public String getHttpsProxy() {
    return this.httpsProxy;
  }
  
  public A withHttpsProxy(String httpsProxy) {
    this.httpsProxy = httpsProxy;
    return (A) this;
  }
  
  public boolean hasHttpsProxy() {
    return this.httpsProxy != null;
  }
  
  public String getMessage() {
    return this.message;
  }
  
  public A withMessage(String message) {
    this.message = message;
    return (A) this;
  }
  
  public boolean hasMessage() {
    return this.message != null;
  }
  
  public String getNoProxy() {
    return this.noProxy;
  }
  
  public A withNoProxy(String noProxy) {
    this.noProxy = noProxy;
    return (A) this;
  }
  
  public boolean hasNoProxy() {
    return this.noProxy != null;
  }
  
  public String getRef() {
    return this.ref;
  }
  
  public A withRef(String ref) {
    this.ref = ref;
    return (A) this;
  }
  
  public boolean hasRef() {
    return this.ref != null;
  }
  
  public A addToRefs(int index,GitRefInfo item) {
    if (this.refs == null) {this.refs = new ArrayList<GitRefInfoBuilder>();}
    GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
    if (index < 0 || index >= refs.size()) { _visitables.get("refs").add(builder); refs.add(builder); } else { _visitables.get("refs").add(index, builder); refs.add(index, builder);}
    return (A)this;
  }
  
  public A setToRefs(int index,GitRefInfo item) {
    if (this.refs == null) {this.refs = new ArrayList<GitRefInfoBuilder>();}
    GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
    if (index < 0 || index >= refs.size()) { _visitables.get("refs").add(builder); refs.add(builder); } else { _visitables.get("refs").set(index, builder); refs.set(index, builder);}
    return (A)this;
  }
  
  public A addToRefs(io.fabric8.openshift.api.model.GitRefInfo... items) {
    if (this.refs == null) {this.refs = new ArrayList<GitRefInfoBuilder>();}
    for (GitRefInfo item : items) {GitRefInfoBuilder builder = new GitRefInfoBuilder(item);_visitables.get("refs").add(builder);this.refs.add(builder);} return (A)this;
  }
  
  public A addAllToRefs(Collection<GitRefInfo> items) {
    if (this.refs == null) {this.refs = new ArrayList<GitRefInfoBuilder>();}
    for (GitRefInfo item : items) {GitRefInfoBuilder builder = new GitRefInfoBuilder(item);_visitables.get("refs").add(builder);this.refs.add(builder);} return (A)this;
  }
  
  public A removeFromRefs(io.fabric8.openshift.api.model.GitRefInfo... items) {
    if (this.refs == null) return (A)this;
    for (GitRefInfo item : items) {GitRefInfoBuilder builder = new GitRefInfoBuilder(item);_visitables.get("refs").remove(builder); this.refs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRefs(Collection<GitRefInfo> items) {
    if (this.refs == null) return (A)this;
    for (GitRefInfo item : items) {GitRefInfoBuilder builder = new GitRefInfoBuilder(item);_visitables.get("refs").remove(builder); this.refs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRefs(Predicate<GitRefInfoBuilder> predicate) {
    if (refs == null) return (A) this;
    final Iterator<GitRefInfoBuilder> each = refs.iterator();
    final List visitables = _visitables.get("refs");
    while (each.hasNext()) {
      GitRefInfoBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GitRefInfo> buildRefs() {
    return this.refs != null ? build(refs) : null;
  }
  
  public GitRefInfo buildRef(int index) {
    return this.refs.get(index).build();
  }
  
  public GitRefInfo buildFirstRef() {
    return this.refs.get(0).build();
  }
  
  public GitRefInfo buildLastRef() {
    return this.refs.get(refs.size() - 1).build();
  }
  
  public GitRefInfo buildMatchingRef(Predicate<GitRefInfoBuilder> predicate) {
      for (GitRefInfoBuilder item : refs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRef(Predicate<GitRefInfoBuilder> predicate) {
      for (GitRefInfoBuilder item : refs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRefs(List<GitRefInfo> refs) {
    if (this.refs != null) {
      this._visitables.get("refs").clear();
    }
    if (refs != null) {
        this.refs = new ArrayList();
        for (GitRefInfo item : refs) {
          this.addToRefs(item);
        }
    } else {
      this.refs = null;
    }
    return (A) this;
  }
  
  public A withRefs(io.fabric8.openshift.api.model.GitRefInfo... refs) {
    if (this.refs != null) {
        this.refs.clear();
        _visitables.remove("refs");
    }
    if (refs != null) {
      for (GitRefInfo item : refs) {
        this.addToRefs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRefs() {
    return this.refs != null && !this.refs.isEmpty();
  }
  
  public RefsNested<A> addNewRef() {
    return new RefsNested(-1, null);
  }
  
  public RefsNested<A> addNewRefLike(GitRefInfo item) {
    return new RefsNested(-1, item);
  }
  
  public RefsNested<A> setNewRefLike(int index,GitRefInfo item) {
    return new RefsNested(index, item);
  }
  
  public RefsNested<A> editRef(int index) {
    if (refs.size() <= index) throw new RuntimeException("Can't edit refs. Index exceeds size.");
    return setNewRefLike(index, buildRef(index));
  }
  
  public RefsNested<A> editFirstRef() {
    if (refs.size() == 0) throw new RuntimeException("Can't edit first refs. The list is empty.");
    return setNewRefLike(0, buildRef(0));
  }
  
  public RefsNested<A> editLastRef() {
    int index = refs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last refs. The list is empty.");
    return setNewRefLike(index, buildRef(index));
  }
  
  public RefsNested<A> editMatchingRef(Predicate<GitRefInfoBuilder> predicate) {
    int index = -1;
    for (int i=0;i<refs.size();i++) { 
    if (predicate.test(refs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching refs. No match found.");
    return setNewRefLike(index, buildRef(index));
  }
  
  public String getUri() {
    return this.uri;
  }
  
  public A withUri(String uri) {
    this.uri = uri;
    return (A) this;
  }
  
  public boolean hasUri() {
    return this.uri != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GitInfoFluent that = (GitInfoFluent) o;
    if (!java.util.Objects.equals(author, that.author)) return false;
    if (!java.util.Objects.equals(commit, that.commit)) return false;
    if (!java.util.Objects.equals(committer, that.committer)) return false;
    if (!java.util.Objects.equals(httpProxy, that.httpProxy)) return false;
    if (!java.util.Objects.equals(httpsProxy, that.httpsProxy)) return false;
    if (!java.util.Objects.equals(message, that.message)) return false;
    if (!java.util.Objects.equals(noProxy, that.noProxy)) return false;
    if (!java.util.Objects.equals(ref, that.ref)) return false;
    if (!java.util.Objects.equals(refs, that.refs)) return false;
    if (!java.util.Objects.equals(uri, that.uri)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(author,  commit,  committer,  httpProxy,  httpsProxy,  message,  noProxy,  ref,  refs,  uri,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (author != null) { sb.append("author:"); sb.append(author + ","); }
    if (commit != null) { sb.append("commit:"); sb.append(commit + ","); }
    if (committer != null) { sb.append("committer:"); sb.append(committer + ","); }
    if (httpProxy != null) { sb.append("httpProxy:"); sb.append(httpProxy + ","); }
    if (httpsProxy != null) { sb.append("httpsProxy:"); sb.append(httpsProxy + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (noProxy != null) { sb.append("noProxy:"); sb.append(noProxy + ","); }
    if (ref != null) { sb.append("ref:"); sb.append(ref + ","); }
    if (refs != null && !refs.isEmpty()) { sb.append("refs:"); sb.append(refs + ","); }
    if (uri != null) { sb.append("uri:"); sb.append(uri + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AuthorNested<N> extends SourceControlUserFluent<AuthorNested<N>> implements Nested<N>{
    AuthorNested(SourceControlUser item) {
      this.builder = new SourceControlUserBuilder(this, item);
    }
    SourceControlUserBuilder builder;
    
    public N and() {
      return (N) GitInfoFluent.this.withAuthor(builder.build());
    }
    
    public N endAuthor() {
      return and();
    }
    
  
  }
  public class CommitterNested<N> extends SourceControlUserFluent<CommitterNested<N>> implements Nested<N>{
    CommitterNested(SourceControlUser item) {
      this.builder = new SourceControlUserBuilder(this, item);
    }
    SourceControlUserBuilder builder;
    
    public N and() {
      return (N) GitInfoFluent.this.withCommitter(builder.build());
    }
    
    public N endCommitter() {
      return and();
    }
    
  
  }
  public class RefsNested<N> extends GitRefInfoFluent<RefsNested<N>> implements Nested<N>{
    RefsNested(int index,GitRefInfo item) {
      this.index = index;
      this.builder = new GitRefInfoBuilder(this, item);
    }
    GitRefInfoBuilder builder;
    int index;
    
    public N and() {
      return (N) GitInfoFluent.this.setToRefs(index,builder.build());
    }
    
    public N endRef() {
      return and();
    }
    
  
  }

}