package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NamedRoleBindingFluent<A extends NamedRoleBindingFluent<A>> extends BaseFluent<A>{
  public NamedRoleBindingFluent() {
  }
  
  public NamedRoleBindingFluent(NamedRoleBinding instance) {
    this.copyInstance(instance);
  }
  private String name;
  private RoleBindingBuilder roleBinding;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NamedRoleBinding instance) {
    instance = (instance != null ? instance : new NamedRoleBinding());
    if (instance != null) {
          this.withName(instance.getName());
          this.withRoleBinding(instance.getRoleBinding());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public RoleBinding buildRoleBinding() {
    return this.roleBinding != null ? this.roleBinding.build() : null;
  }
  
  public A withRoleBinding(RoleBinding roleBinding) {
    this._visitables.remove("roleBinding");
    if (roleBinding != null) {
        this.roleBinding = new RoleBindingBuilder(roleBinding);
        this._visitables.get("roleBinding").add(this.roleBinding);
    } else {
        this.roleBinding = null;
        this._visitables.get("roleBinding").remove(this.roleBinding);
    }
    return (A) this;
  }
  
  public boolean hasRoleBinding() {
    return this.roleBinding != null;
  }
  
  public RoleBindingNested<A> withNewRoleBinding() {
    return new RoleBindingNested(null);
  }
  
  public RoleBindingNested<A> withNewRoleBindingLike(RoleBinding item) {
    return new RoleBindingNested(item);
  }
  
  public RoleBindingNested<A> editRoleBinding() {
    return withNewRoleBindingLike(java.util.Optional.ofNullable(buildRoleBinding()).orElse(null));
  }
  
  public RoleBindingNested<A> editOrNewRoleBinding() {
    return withNewRoleBindingLike(java.util.Optional.ofNullable(buildRoleBinding()).orElse(new RoleBindingBuilder().build()));
  }
  
  public RoleBindingNested<A> editOrNewRoleBindingLike(RoleBinding item) {
    return withNewRoleBindingLike(java.util.Optional.ofNullable(buildRoleBinding()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedRoleBindingFluent that = (NamedRoleBindingFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(roleBinding, that.roleBinding)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  roleBinding,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (roleBinding != null) { sb.append("roleBinding:"); sb.append(roleBinding + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RoleBindingNested<N> extends RoleBindingFluent<RoleBindingNested<N>> implements Nested<N>{
    RoleBindingNested(RoleBinding item) {
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingBuilder builder;
    
    public N and() {
      return (N) NamedRoleBindingFluent.this.withRoleBinding(builder.build());
    }
    
    public N endRoleBinding() {
      return and();
    }
    
  
  }

}