/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ClientConnectionOverrides;
import io.fabric8.openshift.api.model.config.v1.ClientConnectionOverridesBuilder;
import io.fabric8.openshift.api.model.config.v1.ClientConnectionOverridesFluent;
import io.fabric8.openshift.api.model.config.v1.KubeClientConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class KubeClientConfigFluent<A extends KubeClientConfigFluent<A>>
extends BaseFluent<A> {
    private ClientConnectionOverridesBuilder connectionOverrides;
    private String kubeConfig;
    private Map<String, Object> additionalProperties;

    public KubeClientConfigFluent() {
    }

    public KubeClientConfigFluent(KubeClientConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KubeClientConfig instance) {
        KubeClientConfig kubeClientConfig = instance = instance != null ? instance : new KubeClientConfig();
        if (instance != null) {
            this.withConnectionOverrides(instance.getConnectionOverrides());
            this.withKubeConfig(instance.getKubeConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClientConnectionOverrides buildConnectionOverrides() {
        return this.connectionOverrides != null ? this.connectionOverrides.build() : null;
    }

    public A withConnectionOverrides(ClientConnectionOverrides connectionOverrides) {
        this._visitables.remove((Object)"connectionOverrides");
        if (connectionOverrides != null) {
            this.connectionOverrides = new ClientConnectionOverridesBuilder(connectionOverrides);
            this._visitables.get((Object)"connectionOverrides").add(this.connectionOverrides);
        } else {
            this.connectionOverrides = null;
            this._visitables.get((Object)"connectionOverrides").remove((Object)this.connectionOverrides);
        }
        return (A)((Object)this);
    }

    public boolean hasConnectionOverrides() {
        return this.connectionOverrides != null;
    }

    public A withNewConnectionOverrides(String acceptContentTypes, Integer burst, String contentType, Float qps) {
        return this.withConnectionOverrides(new ClientConnectionOverrides(acceptContentTypes, burst, contentType, qps));
    }

    public ConnectionOverridesNested<A> withNewConnectionOverrides() {
        return new ConnectionOverridesNested(null);
    }

    public ConnectionOverridesNested<A> withNewConnectionOverridesLike(ClientConnectionOverrides item) {
        return new ConnectionOverridesNested(item);
    }

    public ConnectionOverridesNested<A> editConnectionOverrides() {
        return this.withNewConnectionOverridesLike(Optional.ofNullable(this.buildConnectionOverrides()).orElse(null));
    }

    public ConnectionOverridesNested<A> editOrNewConnectionOverrides() {
        return this.withNewConnectionOverridesLike(Optional.ofNullable(this.buildConnectionOverrides()).orElse(new ClientConnectionOverridesBuilder().build()));
    }

    public ConnectionOverridesNested<A> editOrNewConnectionOverridesLike(ClientConnectionOverrides item) {
        return this.withNewConnectionOverridesLike(Optional.ofNullable(this.buildConnectionOverrides()).orElse(item));
    }

    public String getKubeConfig() {
        return this.kubeConfig;
    }

    public A withKubeConfig(String kubeConfig) {
        this.kubeConfig = kubeConfig;
        return (A)((Object)this);
    }

    public boolean hasKubeConfig() {
        return this.kubeConfig != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubeClientConfigFluent that = (KubeClientConfigFluent)((Object)o);
        if (!Objects.equals((Object)this.connectionOverrides, (Object)that.connectionOverrides)) {
            return false;
        }
        if (!Objects.equals(this.kubeConfig, that.kubeConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectionOverrides, this.kubeConfig, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connectionOverrides != null) {
            sb.append("connectionOverrides:");
            sb.append(String.valueOf((Object)this.connectionOverrides) + ",");
        }
        if (this.kubeConfig != null) {
            sb.append("kubeConfig:");
            sb.append(this.kubeConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConnectionOverridesNested<N>
    extends ClientConnectionOverridesFluent<ConnectionOverridesNested<N>>
    implements Nested<N> {
        ClientConnectionOverridesBuilder builder;

        ConnectionOverridesNested(ClientConnectionOverrides item) {
            this.builder = new ClientConnectionOverridesBuilder(this, item);
        }

        public N and() {
            return (N)KubeClientConfigFluent.this.withConnectionOverrides(this.builder.build());
        }

        public N endConnectionOverrides() {
            return this.and();
        }
    }
}

