package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildStrategyFluent<A extends BuildStrategyFluent<A>> extends BaseFluent<A>{
  public BuildStrategyFluent() {
  }
  
  public BuildStrategyFluent(BuildStrategy instance) {
    this.copyInstance(instance);
  }
  private CustomBuildStrategyBuilder customStrategy;
  private DockerBuildStrategyBuilder dockerStrategy;
  private JenkinsPipelineBuildStrategyBuilder jenkinsPipelineStrategy;
  private SourceBuildStrategyBuilder sourceStrategy;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BuildStrategy instance) {
    instance = (instance != null ? instance : new BuildStrategy());
    if (instance != null) {
          this.withCustomStrategy(instance.getCustomStrategy());
          this.withDockerStrategy(instance.getDockerStrategy());
          this.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy());
          this.withSourceStrategy(instance.getSourceStrategy());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public CustomBuildStrategy buildCustomStrategy() {
    return this.customStrategy != null ? this.customStrategy.build() : null;
  }
  
  public A withCustomStrategy(CustomBuildStrategy customStrategy) {
    this._visitables.remove("customStrategy");
    if (customStrategy != null) {
        this.customStrategy = new CustomBuildStrategyBuilder(customStrategy);
        this._visitables.get("customStrategy").add(this.customStrategy);
    } else {
        this.customStrategy = null;
        this._visitables.get("customStrategy").remove(this.customStrategy);
    }
    return (A) this;
  }
  
  public boolean hasCustomStrategy() {
    return this.customStrategy != null;
  }
  
  public CustomStrategyNested<A> withNewCustomStrategy() {
    return new CustomStrategyNested(null);
  }
  
  public CustomStrategyNested<A> withNewCustomStrategyLike(CustomBuildStrategy item) {
    return new CustomStrategyNested(item);
  }
  
  public CustomStrategyNested<A> editCustomStrategy() {
    return withNewCustomStrategyLike(java.util.Optional.ofNullable(buildCustomStrategy()).orElse(null));
  }
  
  public CustomStrategyNested<A> editOrNewCustomStrategy() {
    return withNewCustomStrategyLike(java.util.Optional.ofNullable(buildCustomStrategy()).orElse(new CustomBuildStrategyBuilder().build()));
  }
  
  public CustomStrategyNested<A> editOrNewCustomStrategyLike(CustomBuildStrategy item) {
    return withNewCustomStrategyLike(java.util.Optional.ofNullable(buildCustomStrategy()).orElse(item));
  }
  
  public DockerBuildStrategy buildDockerStrategy() {
    return this.dockerStrategy != null ? this.dockerStrategy.build() : null;
  }
  
  public A withDockerStrategy(DockerBuildStrategy dockerStrategy) {
    this._visitables.remove("dockerStrategy");
    if (dockerStrategy != null) {
        this.dockerStrategy = new DockerBuildStrategyBuilder(dockerStrategy);
        this._visitables.get("dockerStrategy").add(this.dockerStrategy);
    } else {
        this.dockerStrategy = null;
        this._visitables.get("dockerStrategy").remove(this.dockerStrategy);
    }
    return (A) this;
  }
  
  public boolean hasDockerStrategy() {
    return this.dockerStrategy != null;
  }
  
  public DockerStrategyNested<A> withNewDockerStrategy() {
    return new DockerStrategyNested(null);
  }
  
  public DockerStrategyNested<A> withNewDockerStrategyLike(DockerBuildStrategy item) {
    return new DockerStrategyNested(item);
  }
  
  public DockerStrategyNested<A> editDockerStrategy() {
    return withNewDockerStrategyLike(java.util.Optional.ofNullable(buildDockerStrategy()).orElse(null));
  }
  
  public DockerStrategyNested<A> editOrNewDockerStrategy() {
    return withNewDockerStrategyLike(java.util.Optional.ofNullable(buildDockerStrategy()).orElse(new DockerBuildStrategyBuilder().build()));
  }
  
  public DockerStrategyNested<A> editOrNewDockerStrategyLike(DockerBuildStrategy item) {
    return withNewDockerStrategyLike(java.util.Optional.ofNullable(buildDockerStrategy()).orElse(item));
  }
  
  public JenkinsPipelineBuildStrategy buildJenkinsPipelineStrategy() {
    return this.jenkinsPipelineStrategy != null ? this.jenkinsPipelineStrategy.build() : null;
  }
  
  public A withJenkinsPipelineStrategy(JenkinsPipelineBuildStrategy jenkinsPipelineStrategy) {
    this._visitables.remove("jenkinsPipelineStrategy");
    if (jenkinsPipelineStrategy != null) {
        this.jenkinsPipelineStrategy = new JenkinsPipelineBuildStrategyBuilder(jenkinsPipelineStrategy);
        this._visitables.get("jenkinsPipelineStrategy").add(this.jenkinsPipelineStrategy);
    } else {
        this.jenkinsPipelineStrategy = null;
        this._visitables.get("jenkinsPipelineStrategy").remove(this.jenkinsPipelineStrategy);
    }
    return (A) this;
  }
  
  public boolean hasJenkinsPipelineStrategy() {
    return this.jenkinsPipelineStrategy != null;
  }
  
  public JenkinsPipelineStrategyNested<A> withNewJenkinsPipelineStrategy() {
    return new JenkinsPipelineStrategyNested(null);
  }
  
  public JenkinsPipelineStrategyNested<A> withNewJenkinsPipelineStrategyLike(JenkinsPipelineBuildStrategy item) {
    return new JenkinsPipelineStrategyNested(item);
  }
  
  public JenkinsPipelineStrategyNested<A> editJenkinsPipelineStrategy() {
    return withNewJenkinsPipelineStrategyLike(java.util.Optional.ofNullable(buildJenkinsPipelineStrategy()).orElse(null));
  }
  
  public JenkinsPipelineStrategyNested<A> editOrNewJenkinsPipelineStrategy() {
    return withNewJenkinsPipelineStrategyLike(java.util.Optional.ofNullable(buildJenkinsPipelineStrategy()).orElse(new JenkinsPipelineBuildStrategyBuilder().build()));
  }
  
  public JenkinsPipelineStrategyNested<A> editOrNewJenkinsPipelineStrategyLike(JenkinsPipelineBuildStrategy item) {
    return withNewJenkinsPipelineStrategyLike(java.util.Optional.ofNullable(buildJenkinsPipelineStrategy()).orElse(item));
  }
  
  public SourceBuildStrategy buildSourceStrategy() {
    return this.sourceStrategy != null ? this.sourceStrategy.build() : null;
  }
  
  public A withSourceStrategy(SourceBuildStrategy sourceStrategy) {
    this._visitables.remove("sourceStrategy");
    if (sourceStrategy != null) {
        this.sourceStrategy = new SourceBuildStrategyBuilder(sourceStrategy);
        this._visitables.get("sourceStrategy").add(this.sourceStrategy);
    } else {
        this.sourceStrategy = null;
        this._visitables.get("sourceStrategy").remove(this.sourceStrategy);
    }
    return (A) this;
  }
  
  public boolean hasSourceStrategy() {
    return this.sourceStrategy != null;
  }
  
  public SourceStrategyNested<A> withNewSourceStrategy() {
    return new SourceStrategyNested(null);
  }
  
  public SourceStrategyNested<A> withNewSourceStrategyLike(SourceBuildStrategy item) {
    return new SourceStrategyNested(item);
  }
  
  public SourceStrategyNested<A> editSourceStrategy() {
    return withNewSourceStrategyLike(java.util.Optional.ofNullable(buildSourceStrategy()).orElse(null));
  }
  
  public SourceStrategyNested<A> editOrNewSourceStrategy() {
    return withNewSourceStrategyLike(java.util.Optional.ofNullable(buildSourceStrategy()).orElse(new SourceBuildStrategyBuilder().build()));
  }
  
  public SourceStrategyNested<A> editOrNewSourceStrategyLike(SourceBuildStrategy item) {
    return withNewSourceStrategyLike(java.util.Optional.ofNullable(buildSourceStrategy()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildStrategyFluent that = (BuildStrategyFluent) o;
    if (!java.util.Objects.equals(customStrategy, that.customStrategy)) return false;
    if (!java.util.Objects.equals(dockerStrategy, that.dockerStrategy)) return false;
    if (!java.util.Objects.equals(jenkinsPipelineStrategy, that.jenkinsPipelineStrategy)) return false;
    if (!java.util.Objects.equals(sourceStrategy, that.sourceStrategy)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(customStrategy,  dockerStrategy,  jenkinsPipelineStrategy,  sourceStrategy,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (customStrategy != null) { sb.append("customStrategy:"); sb.append(customStrategy + ","); }
    if (dockerStrategy != null) { sb.append("dockerStrategy:"); sb.append(dockerStrategy + ","); }
    if (jenkinsPipelineStrategy != null) { sb.append("jenkinsPipelineStrategy:"); sb.append(jenkinsPipelineStrategy + ","); }
    if (sourceStrategy != null) { sb.append("sourceStrategy:"); sb.append(sourceStrategy + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CustomStrategyNested<N> extends CustomBuildStrategyFluent<CustomStrategyNested<N>> implements Nested<N>{
    CustomStrategyNested(CustomBuildStrategy item) {
      this.builder = new CustomBuildStrategyBuilder(this, item);
    }
    CustomBuildStrategyBuilder builder;
    
    public N and() {
      return (N) BuildStrategyFluent.this.withCustomStrategy(builder.build());
    }
    
    public N endCustomStrategy() {
      return and();
    }
    
  
  }
  public class DockerStrategyNested<N> extends DockerBuildStrategyFluent<DockerStrategyNested<N>> implements Nested<N>{
    DockerStrategyNested(DockerBuildStrategy item) {
      this.builder = new DockerBuildStrategyBuilder(this, item);
    }
    DockerBuildStrategyBuilder builder;
    
    public N and() {
      return (N) BuildStrategyFluent.this.withDockerStrategy(builder.build());
    }
    
    public N endDockerStrategy() {
      return and();
    }
    
  
  }
  public class JenkinsPipelineStrategyNested<N> extends JenkinsPipelineBuildStrategyFluent<JenkinsPipelineStrategyNested<N>> implements Nested<N>{
    JenkinsPipelineStrategyNested(JenkinsPipelineBuildStrategy item) {
      this.builder = new JenkinsPipelineBuildStrategyBuilder(this, item);
    }
    JenkinsPipelineBuildStrategyBuilder builder;
    
    public N and() {
      return (N) BuildStrategyFluent.this.withJenkinsPipelineStrategy(builder.build());
    }
    
    public N endJenkinsPipelineStrategy() {
      return and();
    }
    
  
  }
  public class SourceStrategyNested<N> extends SourceBuildStrategyFluent<SourceStrategyNested<N>> implements Nested<N>{
    SourceStrategyNested(SourceBuildStrategy item) {
      this.builder = new SourceBuildStrategyBuilder(this, item);
    }
    SourceBuildStrategyBuilder builder;
    
    public N and() {
      return (N) BuildStrategyFluent.this.withSourceStrategy(builder.build());
    }
    
    public N endSourceStrategy() {
      return and();
    }
    
  
  }

}