package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CustomDeploymentStrategyParamsFluent<A extends CustomDeploymentStrategyParamsFluent<A>> extends BaseFluent<A>{
  public CustomDeploymentStrategyParamsFluent() {
  }
  
  public CustomDeploymentStrategyParamsFluent(CustomDeploymentStrategyParams instance) {
    this.copyInstance(instance);
  }
  private List<String> command = new ArrayList<String>();
  private ArrayList<EnvVarBuilder> environment = new ArrayList<EnvVarBuilder>();
  private String image;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CustomDeploymentStrategyParams instance) {
    instance = (instance != null ? instance : new CustomDeploymentStrategyParams());
    if (instance != null) {
          this.withCommand(instance.getCommand());
          this.withEnvironment(instance.getEnvironment());
          this.withImage(instance.getImage());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.add(index, item);
    return (A)this;
  }
  
  public A setToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.set(index, item); return (A)this;
  }
  
  public A addToCommand(java.lang.String... items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  
  public A addAllToCommand(Collection<String> items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  
  public A removeFromCommand(java.lang.String... items) {
    if (this.command == null) return (A)this;
    for (String item : items) { this.command.remove(item);} return (A)this;
  }
  
  public A removeAllFromCommand(Collection<String> items) {
    if (this.command == null) return (A)this;
    for (String item : items) { this.command.remove(item);} return (A)this;
  }
  
  public List<String> getCommand() {
    return this.command;
  }
  
  public String getCommand(int index) {
    return this.command.get(index);
  }
  
  public String getFirstCommand() {
    return this.command.get(0);
  }
  
  public String getLastCommand() {
    return this.command.get(command.size() - 1);
  }
  
  public String getMatchingCommand(Predicate<String> predicate) {
      for (String item : command) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCommand(Predicate<String> predicate) {
      for (String item : command) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCommand(List<String> command) {
    if (command != null) {
        this.command = new ArrayList();
        for (String item : command) {
          this.addToCommand(item);
        }
    } else {
      this.command = null;
    }
    return (A) this;
  }
  
  public A withCommand(java.lang.String... command) {
    if (this.command != null) {
        this.command.clear();
        _visitables.remove("command");
    }
    if (command != null) {
      for (String item : command) {
        this.addToCommand(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCommand() {
    return this.command != null && !this.command.isEmpty();
  }
  
  public A addToEnvironment(int index,EnvVar item) {
    if (this.environment == null) {this.environment = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= environment.size()) {
        _visitables.get("environment").add(builder);
        environment.add(builder);
    } else {
        _visitables.get("environment").add(builder);
        environment.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToEnvironment(int index,EnvVar item) {
    if (this.environment == null) {this.environment = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= environment.size()) {
        _visitables.get("environment").add(builder);
        environment.add(builder);
    } else {
        _visitables.get("environment").add(builder);
        environment.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToEnvironment(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.environment == null) {this.environment = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("environment").add(builder);this.environment.add(builder);} return (A)this;
  }
  
  public A addAllToEnvironment(Collection<EnvVar> items) {
    if (this.environment == null) {this.environment = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("environment").add(builder);this.environment.add(builder);} return (A)this;
  }
  
  public A removeFromEnvironment(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.environment == null) return (A)this;
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("environment").remove(builder); this.environment.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEnvironment(Collection<EnvVar> items) {
    if (this.environment == null) return (A)this;
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("environment").remove(builder); this.environment.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEnvironment(Predicate<EnvVarBuilder> predicate) {
    if (environment == null) return (A) this;
    final Iterator<EnvVarBuilder> each = environment.iterator();
    final List visitables = _visitables.get("environment");
    while (each.hasNext()) {
      EnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EnvVar> buildEnvironment() {
    return this.environment != null ? build(environment) : null;
  }
  
  public EnvVar buildEnvironment(int index) {
    return this.environment.get(index).build();
  }
  
  public EnvVar buildFirstEnvironment() {
    return this.environment.get(0).build();
  }
  
  public EnvVar buildLastEnvironment() {
    return this.environment.get(environment.size() - 1).build();
  }
  
  public EnvVar buildMatchingEnvironment(Predicate<EnvVarBuilder> predicate) {
      for (EnvVarBuilder item : environment) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnvironment(Predicate<EnvVarBuilder> predicate) {
      for (EnvVarBuilder item : environment) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEnvironment(List<EnvVar> environment) {
    if (this.environment != null) {
      this._visitables.get("environment").clear();
    }
    if (environment != null) {
        this.environment = new ArrayList();
        for (EnvVar item : environment) {
          this.addToEnvironment(item);
        }
    } else {
      this.environment = null;
    }
    return (A) this;
  }
  
  public A withEnvironment(io.fabric8.kubernetes.api.model.EnvVar... environment) {
    if (this.environment != null) {
        this.environment.clear();
        _visitables.remove("environment");
    }
    if (environment != null) {
      for (EnvVar item : environment) {
        this.addToEnvironment(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEnvironment() {
    return this.environment != null && !this.environment.isEmpty();
  }
  
  public EnvironmentNested<A> addNewEnvironment() {
    return new EnvironmentNested(-1, null);
  }
  
  public EnvironmentNested<A> addNewEnvironmentLike(EnvVar item) {
    return new EnvironmentNested(-1, item);
  }
  
  public EnvironmentNested<A> setNewEnvironmentLike(int index,EnvVar item) {
    return new EnvironmentNested(index, item);
  }
  
  public EnvironmentNested<A> editEnvironment(int index) {
    if (environment.size() <= index) throw new RuntimeException("Can't edit environment. Index exceeds size.");
    return setNewEnvironmentLike(index, buildEnvironment(index));
  }
  
  public EnvironmentNested<A> editFirstEnvironment() {
    if (environment.size() == 0) throw new RuntimeException("Can't edit first environment. The list is empty.");
    return setNewEnvironmentLike(0, buildEnvironment(0));
  }
  
  public EnvironmentNested<A> editLastEnvironment() {
    int index = environment.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last environment. The list is empty.");
    return setNewEnvironmentLike(index, buildEnvironment(index));
  }
  
  public EnvironmentNested<A> editMatchingEnvironment(Predicate<EnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<environment.size();i++) { 
    if (predicate.test(environment.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching environment. No match found.");
    return setNewEnvironmentLike(index, buildEnvironment(index));
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomDeploymentStrategyParamsFluent that = (CustomDeploymentStrategyParamsFluent) o;
    if (!java.util.Objects.equals(command, that.command)) return false;
    if (!java.util.Objects.equals(environment, that.environment)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(command,  environment,  image,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (command != null && !command.isEmpty()) { sb.append("command:"); sb.append(command + ","); }
    if (environment != null && !environment.isEmpty()) { sb.append("environment:"); sb.append(environment + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EnvironmentNested<N> extends EnvVarFluent<EnvironmentNested<N>> implements Nested<N>{
    EnvironmentNested(int index,EnvVar item) {
      this.index = index;
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarBuilder builder;
    int index;
    
    public N and() {
      return (N) CustomDeploymentStrategyParamsFluent.this.setToEnvironment(index,builder.build());
    }
    
    public N endEnvironment() {
      return and();
    }
    
  
  }

}