/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ImageImportStatus;
import io.fabric8.openshift.api.model.ImageImportStatusBuilder;
import io.fabric8.openshift.api.model.ImageImportStatusFluent;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamImportStatus;
import io.fabric8.openshift.api.model.RepositoryImportStatus;
import io.fabric8.openshift.api.model.RepositoryImportStatusBuilder;
import io.fabric8.openshift.api.model.RepositoryImportStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImageStreamImportStatusFluent<A extends ImageStreamImportStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ImageImportStatusBuilder> images = new ArrayList();
    private ImageStreamBuilder _import;
    private RepositoryImportStatusBuilder repository;
    private Map<String, Object> additionalProperties;

    public ImageStreamImportStatusFluent() {
    }

    public ImageStreamImportStatusFluent(ImageStreamImportStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ImageStreamImportStatus instance) {
        ImageStreamImportStatus imageStreamImportStatus = instance = instance != null ? instance : new ImageStreamImportStatus();
        if (instance != null) {
            this.withImages(instance.getImages());
            this.withImport(instance.getImport());
            this.withRepository(instance.getRepository());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToImages(int index, ImageImportStatus item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get((Object)"images").add(builder);
            this.images.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToImages(int index, ImageImportStatus item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get((Object)"images").add(builder);
            this.images.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToImages(ImageImportStatus ... items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToImages(Collection<ImageImportStatus> items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromImages(ImageImportStatus ... items) {
        if (this.images == null) {
            return (A)((Object)this);
        }
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get((Object)"images").remove((Object)builder);
            this.images.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromImages(Collection<ImageImportStatus> items) {
        if (this.images == null) {
            return (A)((Object)this);
        }
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get((Object)"images").remove((Object)builder);
            this.images.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromImages(Predicate<ImageImportStatusBuilder> predicate) {
        if (this.images == null) {
            return (A)((Object)this);
        }
        Iterator<ImageImportStatusBuilder> each = this.images.iterator();
        List visitables = this._visitables.get((Object)"images");
        while (each.hasNext()) {
            ImageImportStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ImageImportStatus> buildImages() {
        return this.images != null ? ImageStreamImportStatusFluent.build(this.images) : null;
    }

    public ImageImportStatus buildImage(int index) {
        return this.images.get(index).build();
    }

    public ImageImportStatus buildFirstImage() {
        return this.images.get(0).build();
    }

    public ImageImportStatus buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    public ImageImportStatus buildMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        for (ImageImportStatusBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        for (ImageImportStatusBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImages(List<ImageImportStatus> images) {
        if (this.images != null) {
            this._visitables.get((Object)"images").clear();
        }
        if (images != null) {
            this.images = new ArrayList();
            for (ImageImportStatus item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)((Object)this);
    }

    public A withImages(ImageImportStatus ... images) {
        if (this.images != null) {
            this.images.clear();
            this._visitables.remove((Object)"images");
        }
        if (images != null) {
            for (ImageImportStatus item : images) {
                this.addToImages(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    public ImagesNested<A> addNewImage() {
        return new ImagesNested(-1, null);
    }

    public ImagesNested<A> addNewImageLike(ImageImportStatus item) {
        return new ImagesNested(-1, item);
    }

    public ImagesNested<A> setNewImageLike(int index, ImageImportStatus item) {
        return new ImagesNested(index, item);
    }

    public ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    public ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public ImagesNested<A> editMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.test(this.images.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public ImageStream buildImport() {
        return this._import != null ? this._import.build() : null;
    }

    public A withImport(ImageStream _import) {
        this._visitables.remove((Object)"_import");
        if (_import != null) {
            this._import = new ImageStreamBuilder(_import);
            this._visitables.get((Object)"_import").add(this._import);
        } else {
            this._import = null;
            this._visitables.get((Object)"_import").remove((Object)this._import);
        }
        return (A)((Object)this);
    }

    public boolean hasImport() {
        return this._import != null;
    }

    public ImportNested<A> withNewImport() {
        return new ImportNested(null);
    }

    public ImportNested<A> withNewImportLike(ImageStream item) {
        return new ImportNested(item);
    }

    public ImportNested<A> editImport() {
        return this.withNewImportLike(Optional.ofNullable(this.buildImport()).orElse(null));
    }

    public ImportNested<A> editOrNewImport() {
        return this.withNewImportLike(Optional.ofNullable(this.buildImport()).orElse(new ImageStreamBuilder().build()));
    }

    public ImportNested<A> editOrNewImportLike(ImageStream item) {
        return this.withNewImportLike(Optional.ofNullable(this.buildImport()).orElse(item));
    }

    public RepositoryImportStatus buildRepository() {
        return this.repository != null ? this.repository.build() : null;
    }

    public A withRepository(RepositoryImportStatus repository) {
        this._visitables.remove((Object)"repository");
        if (repository != null) {
            this.repository = new RepositoryImportStatusBuilder(repository);
            this._visitables.get((Object)"repository").add(this.repository);
        } else {
            this.repository = null;
            this._visitables.get((Object)"repository").remove((Object)this.repository);
        }
        return (A)((Object)this);
    }

    public boolean hasRepository() {
        return this.repository != null;
    }

    public RepositoryNested<A> withNewRepository() {
        return new RepositoryNested(null);
    }

    public RepositoryNested<A> withNewRepositoryLike(RepositoryImportStatus item) {
        return new RepositoryNested(item);
    }

    public RepositoryNested<A> editRepository() {
        return this.withNewRepositoryLike(Optional.ofNullable(this.buildRepository()).orElse(null));
    }

    public RepositoryNested<A> editOrNewRepository() {
        return this.withNewRepositoryLike(Optional.ofNullable(this.buildRepository()).orElse(new RepositoryImportStatusBuilder().build()));
    }

    public RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportStatus item) {
        return this.withNewRepositoryLike(Optional.ofNullable(this.buildRepository()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamImportStatusFluent that = (ImageStreamImportStatusFluent)((Object)o);
        if (!Objects.equals(this.images, that.images)) {
            return false;
        }
        if (!Objects.equals((Object)this._import, (Object)that._import)) {
            return false;
        }
        if (!Objects.equals((Object)this.repository, (Object)that.repository)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.images, this._import, this.repository, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.images != null && !this.images.isEmpty()) {
            sb.append("images:");
            sb.append(String.valueOf(this.images) + ",");
        }
        if (this._import != null) {
            sb.append("_import:");
            sb.append(String.valueOf((Object)this._import) + ",");
        }
        if (this.repository != null) {
            sb.append("repository:");
            sb.append(String.valueOf((Object)this.repository) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RepositoryNested<N>
    extends RepositoryImportStatusFluent<RepositoryNested<N>>
    implements Nested<N> {
        RepositoryImportStatusBuilder builder;

        RepositoryNested(RepositoryImportStatus item) {
            this.builder = new RepositoryImportStatusBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamImportStatusFluent.this.withRepository(this.builder.build());
        }

        public N endRepository() {
            return this.and();
        }
    }

    public class ImportNested<N>
    extends ImageStreamFluent<ImportNested<N>>
    implements Nested<N> {
        ImageStreamBuilder builder;

        ImportNested(ImageStream item) {
            this.builder = new ImageStreamBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamImportStatusFluent.this.withImport(this.builder.build());
        }

        public N endImport() {
            return this.and();
        }
    }

    public class ImagesNested<N>
    extends ImageImportStatusFluent<ImagesNested<N>>
    implements Nested<N> {
        ImageImportStatusBuilder builder;
        int index;

        ImagesNested(int index, ImageImportStatus item) {
            this.index = index;
            this.builder = new ImageImportStatusBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamImportStatusFluent.this.setToImages(this.index, this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }
}

