/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.openshift.api.model.ImageFluent;
import io.fabric8.openshift.api.model.ImageLookupPolicy;
import io.fabric8.openshift.api.model.ImageLookupPolicyBuilder;
import io.fabric8.openshift.api.model.ImageLookupPolicyFluent;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.TagEventCondition;
import io.fabric8.openshift.api.model.TagEventConditionBuilder;
import io.fabric8.openshift.api.model.TagEventConditionFluent;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceBuilder;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImageStreamTagFluent<A extends ImageStreamTagFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private ArrayList<TagEventConditionBuilder> conditions = new ArrayList();
    private Long generation;
    private ImageBuilder image;
    private String kind;
    private ImageLookupPolicyBuilder lookupPolicy;
    private ObjectMetaBuilder metadata;
    private TagReferenceBuilder tag;

    public ImageStreamTagFluent() {
    }

    public ImageStreamTagFluent(ImageStreamTag instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<TagEventCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(TagEventCondition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(TagEventCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, TagEventCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public TagEventCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<TagEventCondition> buildConditions() {
        return this.conditions != null ? ImageStreamTagFluent.build(this.conditions) : null;
    }

    public TagEventCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Image buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    public TagEventCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public ImageLookupPolicy buildLookupPolicy() {
        return this.lookupPolicy != null ? this.lookupPolicy.build() : null;
    }

    public TagEventCondition buildMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        for (TagEventConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public TagReference buildTag() {
        return this.tag != null ? this.tag.build() : null;
    }

    protected void copyInstance(ImageStreamTag instance) {
        ImageStreamTag imageStreamTag = instance = instance != null ? instance : new ImageStreamTag();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withConditions(instance.getConditions());
            this.withGeneration(instance.getGeneration());
            this.withImage(instance.getImage());
            this.withKind(instance.getKind());
            this.withLookupPolicy(instance.getLookupPolicy());
            this.withMetadata(instance.getMetadata());
            this.withTag(instance.getTag());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ImageNested<A> editImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(null));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public LookupPolicyNested<A> editLookupPolicy() {
        return this.withNewLookupPolicyLike(Optional.ofNullable(this.buildLookupPolicy()).orElse(null));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(new ImageBuilder().build()));
    }

    public ImageNested<A> editOrNewImageLike(Image item) {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(item));
    }

    public LookupPolicyNested<A> editOrNewLookupPolicy() {
        return this.withNewLookupPolicyLike(Optional.ofNullable(this.buildLookupPolicy()).orElse(new ImageLookupPolicyBuilder().build()));
    }

    public LookupPolicyNested<A> editOrNewLookupPolicyLike(ImageLookupPolicy item) {
        return this.withNewLookupPolicyLike(Optional.ofNullable(this.buildLookupPolicy()).orElse(item));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public TagNested<A> editOrNewTag() {
        return this.withNewTagLike(Optional.ofNullable(this.buildTag()).orElse(new TagReferenceBuilder().build()));
    }

    public TagNested<A> editOrNewTagLike(TagReference item) {
        return this.withNewTagLike(Optional.ofNullable(this.buildTag()).orElse(item));
    }

    public TagNested<A> editTag() {
        return this.withNewTagLike(Optional.ofNullable(this.buildTag()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamTagFluent that = (ImageStreamTagFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.generation, that.generation)) {
            return false;
        }
        if (!Objects.equals((Object)this.image, (Object)that.image)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals((Object)this.lookupPolicy, (Object)that.lookupPolicy)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals((Object)this.tag, (Object)that.tag)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Long getGeneration() {
        return this.generation;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasGeneration() {
        return this.generation != null;
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasLookupPolicy() {
        return this.lookupPolicy != null;
    }

    public boolean hasMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        for (TagEventConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.conditions, this.generation, this.image, this.kind, this.lookupPolicy, this.metadata, this.tag, this.additionalProperties});
    }

    public A removeAllFromConditions(Collection<TagEventCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(TagEventCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<TagEventConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<TagEventConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            TagEventConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> setNewConditionLike(int index, TagEventCondition item) {
        return new ConditionsNested(index, item);
    }

    public A setToConditions(int index, TagEventCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.generation != null) {
            sb.append("generation:");
            sb.append(this.generation);
            sb.append(",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append((Object)this.image);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.lookupPolicy != null) {
            sb.append("lookupPolicy:");
            sb.append((Object)this.lookupPolicy);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.tag != null) {
            sb.append("tag:");
            sb.append((Object)this.tag);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withConditions(List<TagEventCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(TagEventCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)((Object)this);
    }

    public A withImage(Image image) {
        this._visitables.remove((Object)"image");
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.get((Object)"image").add(this.image);
        } else {
            this.image = null;
            this._visitables.get((Object)"image").remove((Object)this.image);
        }
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withLookupPolicy(ImageLookupPolicy lookupPolicy) {
        this._visitables.remove((Object)"lookupPolicy");
        if (lookupPolicy != null) {
            this.lookupPolicy = new ImageLookupPolicyBuilder(lookupPolicy);
            this._visitables.get((Object)"lookupPolicy").add(this.lookupPolicy);
        } else {
            this.lookupPolicy = null;
            this._visitables.get((Object)"lookupPolicy").remove((Object)this.lookupPolicy);
        }
        return (A)((Object)this);
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public ImageNested<A> withNewImage() {
        return new ImageNested(null);
    }

    public ImageNested<A> withNewImageLike(Image item) {
        return new ImageNested(item);
    }

    public LookupPolicyNested<A> withNewLookupPolicy() {
        return new LookupPolicyNested(null);
    }

    public A withNewLookupPolicy(Boolean local) {
        return this.withLookupPolicy(new ImageLookupPolicy(local));
    }

    public LookupPolicyNested<A> withNewLookupPolicyLike(ImageLookupPolicy item) {
        return new LookupPolicyNested(item);
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public TagNested<A> withNewTag() {
        return new TagNested(null);
    }

    public TagNested<A> withNewTagLike(TagReference item) {
        return new TagNested(item);
    }

    public A withTag(TagReference tag) {
        this._visitables.remove((Object)"tag");
        if (tag != null) {
            this.tag = new TagReferenceBuilder(tag);
            this._visitables.get((Object)"tag").add(this.tag);
        } else {
            this.tag = null;
            this._visitables.get((Object)"tag").remove((Object)this.tag);
        }
        return (A)((Object)this);
    }

    public class TagNested<N>
    extends TagReferenceFluent<TagNested<N>>
    implements Nested<N> {
        TagReferenceBuilder builder;

        TagNested(TagReference item) {
            this.builder = new TagReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamTagFluent.this.withTag(this.builder.build());
        }

        public N endTag() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)ImageStreamTagFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class LookupPolicyNested<N>
    extends ImageLookupPolicyFluent<LookupPolicyNested<N>>
    implements Nested<N> {
        ImageLookupPolicyBuilder builder;

        LookupPolicyNested(ImageLookupPolicy item) {
            this.builder = new ImageLookupPolicyBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamTagFluent.this.withLookupPolicy(this.builder.build());
        }

        public N endLookupPolicy() {
            return this.and();
        }
    }

    public class ImageNested<N>
    extends ImageFluent<ImageNested<N>>
    implements Nested<N> {
        ImageBuilder builder;

        ImageNested(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamTagFluent.this.withImage(this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends TagEventConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        TagEventConditionBuilder builder;
        int index;

        ConditionsNested(int index, TagEventCondition item) {
            this.index = index;
            this.builder = new TagEventConditionBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamTagFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

