/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ExecNewPodHook;
import io.fabric8.openshift.api.model.ExecNewPodHookBuilder;
import io.fabric8.openshift.api.model.ExecNewPodHookFluent;
import io.fabric8.openshift.api.model.LifecycleHook;
import io.fabric8.openshift.api.model.TagImageHook;
import io.fabric8.openshift.api.model.TagImageHookBuilder;
import io.fabric8.openshift.api.model.TagImageHookFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class LifecycleHookFluent<A extends LifecycleHookFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ExecNewPodHookBuilder execNewPod;
    private String failurePolicy;
    private ArrayList<TagImageHookBuilder> tagImages = new ArrayList();

    public LifecycleHookFluent() {
    }

    public LifecycleHookFluent(LifecycleHook instance) {
        this.copyInstance(instance);
    }

    public A addAllToTagImages(Collection<TagImageHook> items) {
        if (this.tagImages == null) {
            this.tagImages = new ArrayList();
        }
        for (TagImageHook item : items) {
            TagImageHookBuilder builder = new TagImageHookBuilder(item);
            this._visitables.get((Object)"tagImages").add(builder);
            this.tagImages.add(builder);
        }
        return (A)((Object)this);
    }

    public TagImagesNested<A> addNewTagImage() {
        return new TagImagesNested(-1, null);
    }

    public TagImagesNested<A> addNewTagImageLike(TagImageHook item) {
        return new TagImagesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTagImages(TagImageHook ... items) {
        if (this.tagImages == null) {
            this.tagImages = new ArrayList();
        }
        for (TagImageHook item : items) {
            TagImageHookBuilder builder = new TagImageHookBuilder(item);
            this._visitables.get((Object)"tagImages").add(builder);
            this.tagImages.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToTagImages(int index, TagImageHook item) {
        if (this.tagImages == null) {
            this.tagImages = new ArrayList();
        }
        TagImageHookBuilder builder = new TagImageHookBuilder(item);
        if (index < 0 || index >= this.tagImages.size()) {
            this._visitables.get((Object)"tagImages").add(builder);
            this.tagImages.add(builder);
        } else {
            this._visitables.get((Object)"tagImages").add(builder);
            this.tagImages.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ExecNewPodHook buildExecNewPod() {
        return this.execNewPod != null ? this.execNewPod.build() : null;
    }

    public TagImageHook buildFirstTagImage() {
        return this.tagImages.get(0).build();
    }

    public TagImageHook buildLastTagImage() {
        return this.tagImages.get(this.tagImages.size() - 1).build();
    }

    public TagImageHook buildMatchingTagImage(Predicate<TagImageHookBuilder> predicate) {
        for (TagImageHookBuilder item : this.tagImages) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public TagImageHook buildTagImage(int index) {
        return this.tagImages.get(index).build();
    }

    public List<TagImageHook> buildTagImages() {
        return this.tagImages != null ? LifecycleHookFluent.build(this.tagImages) : null;
    }

    protected void copyInstance(LifecycleHook instance) {
        LifecycleHook lifecycleHook = instance = instance != null ? instance : new LifecycleHook();
        if (instance != null) {
            this.withExecNewPod(instance.getExecNewPod());
            this.withFailurePolicy(instance.getFailurePolicy());
            this.withTagImages(instance.getTagImages());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ExecNewPodNested<A> editExecNewPod() {
        return this.withNewExecNewPodLike(Optional.ofNullable(this.buildExecNewPod()).orElse(null));
    }

    public TagImagesNested<A> editFirstTagImage() {
        if (this.tagImages.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "tagImages"));
        }
        return this.setNewTagImageLike(0, this.buildTagImage(0));
    }

    public TagImagesNested<A> editLastTagImage() {
        int index = this.tagImages.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "tagImages"));
        }
        return this.setNewTagImageLike(index, this.buildTagImage(index));
    }

    public TagImagesNested<A> editMatchingTagImage(Predicate<TagImageHookBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tagImages.size(); ++i) {
            if (!predicate.test(this.tagImages.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "tagImages"));
        }
        return this.setNewTagImageLike(index, this.buildTagImage(index));
    }

    public ExecNewPodNested<A> editOrNewExecNewPod() {
        return this.withNewExecNewPodLike(Optional.ofNullable(this.buildExecNewPod()).orElse(new ExecNewPodHookBuilder().build()));
    }

    public ExecNewPodNested<A> editOrNewExecNewPodLike(ExecNewPodHook item) {
        return this.withNewExecNewPodLike(Optional.ofNullable(this.buildExecNewPod()).orElse(item));
    }

    public TagImagesNested<A> editTagImage(int index) {
        if (this.tagImages.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "tagImages"));
        }
        return this.setNewTagImageLike(index, this.buildTagImage(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LifecycleHookFluent that = (LifecycleHookFluent)((Object)o);
        if (!Objects.equals((Object)this.execNewPod, (Object)that.execNewPod)) {
            return false;
        }
        if (!Objects.equals(this.failurePolicy, that.failurePolicy)) {
            return false;
        }
        if (!Objects.equals(this.tagImages, that.tagImages)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasExecNewPod() {
        return this.execNewPod != null;
    }

    public boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    public boolean hasMatchingTagImage(Predicate<TagImageHookBuilder> predicate) {
        for (TagImageHookBuilder item : this.tagImages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTagImages() {
        return this.tagImages != null && !this.tagImages.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.execNewPod, this.failurePolicy, this.tagImages, this.additionalProperties});
    }

    public A removeAllFromTagImages(Collection<TagImageHook> items) {
        if (this.tagImages == null) {
            return (A)((Object)this);
        }
        for (TagImageHook item : items) {
            TagImageHookBuilder builder = new TagImageHookBuilder(item);
            this._visitables.get((Object)"tagImages").remove((Object)builder);
            this.tagImages.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromTagImages(TagImageHook ... items) {
        if (this.tagImages == null) {
            return (A)((Object)this);
        }
        for (TagImageHook item : items) {
            TagImageHookBuilder builder = new TagImageHookBuilder(item);
            this._visitables.get((Object)"tagImages").remove((Object)builder);
            this.tagImages.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTagImages(Predicate<TagImageHookBuilder> predicate) {
        if (this.tagImages == null) {
            return (A)((Object)this);
        }
        Iterator<TagImageHookBuilder> each = this.tagImages.iterator();
        List visitables = this._visitables.get((Object)"tagImages");
        while (each.hasNext()) {
            TagImageHookBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public TagImagesNested<A> setNewTagImageLike(int index, TagImageHook item) {
        return new TagImagesNested(index, item);
    }

    public A setToTagImages(int index, TagImageHook item) {
        if (this.tagImages == null) {
            this.tagImages = new ArrayList();
        }
        TagImageHookBuilder builder = new TagImageHookBuilder(item);
        if (index < 0 || index >= this.tagImages.size()) {
            this._visitables.get((Object)"tagImages").add(builder);
            this.tagImages.add(builder);
        } else {
            this._visitables.get((Object)"tagImages").add(builder);
            this.tagImages.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.execNewPod != null) {
            sb.append("execNewPod:");
            sb.append((Object)this.execNewPod);
            sb.append(",");
        }
        if (this.failurePolicy != null) {
            sb.append("failurePolicy:");
            sb.append(this.failurePolicy);
            sb.append(",");
        }
        if (this.tagImages != null && !this.tagImages.isEmpty()) {
            sb.append("tagImages:");
            sb.append(this.tagImages);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withExecNewPod(ExecNewPodHook execNewPod) {
        this._visitables.remove((Object)"execNewPod");
        if (execNewPod != null) {
            this.execNewPod = new ExecNewPodHookBuilder(execNewPod);
            this._visitables.get((Object)"execNewPod").add(this.execNewPod);
        } else {
            this.execNewPod = null;
            this._visitables.get((Object)"execNewPod").remove((Object)this.execNewPod);
        }
        return (A)((Object)this);
    }

    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return (A)((Object)this);
    }

    public ExecNewPodNested<A> withNewExecNewPod() {
        return new ExecNewPodNested(null);
    }

    public ExecNewPodNested<A> withNewExecNewPodLike(ExecNewPodHook item) {
        return new ExecNewPodNested(item);
    }

    public A withTagImages(List<TagImageHook> tagImages) {
        if (this.tagImages != null) {
            this._visitables.get((Object)"tagImages").clear();
        }
        if (tagImages != null) {
            this.tagImages = new ArrayList();
            for (TagImageHook item : tagImages) {
                this.addToTagImages(item);
            }
        } else {
            this.tagImages = null;
        }
        return (A)((Object)this);
    }

    public A withTagImages(TagImageHook ... tagImages) {
        if (this.tagImages != null) {
            this.tagImages.clear();
            this._visitables.remove((Object)"tagImages");
        }
        if (tagImages != null) {
            for (TagImageHook item : tagImages) {
                this.addToTagImages(item);
            }
        }
        return (A)((Object)this);
    }

    public class TagImagesNested<N>
    extends TagImageHookFluent<TagImagesNested<N>>
    implements Nested<N> {
        TagImageHookBuilder builder;
        int index;

        TagImagesNested(int index, TagImageHook item) {
            this.index = index;
            this.builder = new TagImageHookBuilder(this, item);
        }

        public N and() {
            return (N)LifecycleHookFluent.this.setToTagImages(this.index, this.builder.build());
        }

        public N endTagImage() {
            return this.and();
        }
    }

    public class ExecNewPodNested<N>
    extends ExecNewPodHookFluent<ExecNewPodNested<N>>
    implements Nested<N> {
        ExecNewPodHookBuilder builder;

        ExecNewPodNested(ExecNewPodHook item) {
            this.builder = new ExecNewPodHookBuilder(this, item);
        }

        public N and() {
            return (N)LifecycleHookFluent.this.withExecNewPod(this.builder.build());
        }

        public N endExecNewPod() {
            return this.and();
        }
    }
}

