/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.DeploymentRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeploymentRequestFluent<A extends DeploymentRequestFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private List<String> excludeTriggers = new ArrayList<String>();
    private Boolean force;
    private String kind;
    private Boolean latest;
    private String name;

    public DeploymentRequestFluent() {
    }

    public DeploymentRequestFluent(DeploymentRequest instance) {
        this.copyInstance(instance);
    }

    public A addAllToExcludeTriggers(Collection<String> items) {
        if (this.excludeTriggers == null) {
            this.excludeTriggers = new ArrayList<String>();
        }
        for (String item : items) {
            this.excludeTriggers.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToExcludeTriggers(String ... items) {
        if (this.excludeTriggers == null) {
            this.excludeTriggers = new ArrayList<String>();
        }
        for (String item : items) {
            this.excludeTriggers.add(item);
        }
        return (A)((Object)this);
    }

    public A addToExcludeTriggers(int index, String item) {
        if (this.excludeTriggers == null) {
            this.excludeTriggers = new ArrayList<String>();
        }
        this.excludeTriggers.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(DeploymentRequest instance) {
        DeploymentRequest deploymentRequest = instance = instance != null ? instance : new DeploymentRequest();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withExcludeTriggers(instance.getExcludeTriggers());
            this.withForce(instance.getForce());
            this.withKind(instance.getKind());
            this.withLatest(instance.getLatest());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentRequestFluent that = (DeploymentRequestFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.excludeTriggers, that.excludeTriggers)) {
            return false;
        }
        if (!Objects.equals(this.force, that.force)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.latest, that.latest)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getExcludeTrigger(int index) {
        return this.excludeTriggers.get(index);
    }

    public List<String> getExcludeTriggers() {
        return this.excludeTriggers;
    }

    public String getFirstExcludeTrigger() {
        return this.excludeTriggers.get(0);
    }

    public Boolean getForce() {
        return this.force;
    }

    public String getKind() {
        return this.kind;
    }

    public String getLastExcludeTrigger() {
        return this.excludeTriggers.get(this.excludeTriggers.size() - 1);
    }

    public Boolean getLatest() {
        return this.latest;
    }

    public String getMatchingExcludeTrigger(Predicate<String> predicate) {
        for (String item : this.excludeTriggers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasExcludeTriggers() {
        return this.excludeTriggers != null && !this.excludeTriggers.isEmpty();
    }

    public boolean hasForce() {
        return this.force != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasLatest() {
        return this.latest != null;
    }

    public boolean hasMatchingExcludeTrigger(Predicate<String> predicate) {
        for (String item : this.excludeTriggers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.excludeTriggers, this.force, this.kind, this.latest, this.name, this.additionalProperties);
    }

    public A removeAllFromExcludeTriggers(Collection<String> items) {
        if (this.excludeTriggers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.excludeTriggers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromExcludeTriggers(String ... items) {
        if (this.excludeTriggers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.excludeTriggers.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToExcludeTriggers(int index, String item) {
        if (this.excludeTriggers == null) {
            this.excludeTriggers = new ArrayList<String>();
        }
        this.excludeTriggers.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.excludeTriggers != null && !this.excludeTriggers.isEmpty()) {
            sb.append("excludeTriggers:");
            sb.append(this.excludeTriggers);
            sb.append(",");
        }
        if (this.force != null) {
            sb.append("force:");
            sb.append(this.force);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.latest != null) {
            sb.append("latest:");
            sb.append(this.latest);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withExcludeTriggers(List<String> excludeTriggers) {
        if (excludeTriggers != null) {
            this.excludeTriggers = new ArrayList<String>();
            for (String item : excludeTriggers) {
                this.addToExcludeTriggers(item);
            }
        } else {
            this.excludeTriggers = null;
        }
        return (A)((Object)this);
    }

    public A withExcludeTriggers(String ... excludeTriggers) {
        if (this.excludeTriggers != null) {
            this.excludeTriggers.clear();
            this._visitables.remove((Object)"excludeTriggers");
        }
        if (excludeTriggers != null) {
            for (String item : excludeTriggers) {
                this.addToExcludeTriggers(item);
            }
        }
        return (A)((Object)this);
    }

    public A withForce() {
        return this.withForce(true);
    }

    public A withForce(Boolean force) {
        this.force = force;
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withLatest() {
        return this.withLatest(true);
    }

    public A withLatest(Boolean latest) {
        this.latest = latest;
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }
}

