/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.LocalResourceAccessReview;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LocalResourceAccessReviewFluent<A extends LocalResourceAccessReviewFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private Object content;
    private Boolean isNonResourceURL;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String namespace;
    private String path;
    private String resource;
    private String resourceAPIGroup;
    private String resourceAPIVersion;
    private String resourceName;
    private String verb;

    public LocalResourceAccessReviewFluent() {
    }

    public LocalResourceAccessReviewFluent(LocalResourceAccessReview instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    protected void copyInstance(LocalResourceAccessReview instance) {
        LocalResourceAccessReview localResourceAccessReview = instance = instance != null ? instance : new LocalResourceAccessReview();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withContent(instance.getContent());
            this.withIsNonResourceURL(instance.getIsNonResourceURL());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNamespace(instance.getNamespace());
            this.withPath(instance.getPath());
            this.withResource(instance.getResource());
            this.withResourceAPIGroup(instance.getResourceAPIGroup());
            this.withResourceAPIVersion(instance.getResourceAPIVersion());
            this.withResourceName(instance.getResourceName());
            this.withVerb(instance.getVerb());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalResourceAccessReviewFluent that = (LocalResourceAccessReviewFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.content, that.content)) {
            return false;
        }
        if (!Objects.equals(this.isNonResourceURL, that.isNonResourceURL)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        if (!Objects.equals(this.resourceAPIGroup, that.resourceAPIGroup)) {
            return false;
        }
        if (!Objects.equals(this.resourceAPIVersion, that.resourceAPIVersion)) {
            return false;
        }
        if (!Objects.equals(this.resourceName, that.resourceName)) {
            return false;
        }
        if (!Objects.equals(this.verb, that.verb)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Object getContent() {
        return this.content;
    }

    public Boolean getIsNonResourceURL() {
        return this.isNonResourceURL;
    }

    public String getKind() {
        return this.kind;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPath() {
        return this.path;
    }

    public String getResource() {
        return this.resource;
    }

    public String getResourceAPIGroup() {
        return this.resourceAPIGroup;
    }

    public String getResourceAPIVersion() {
        return this.resourceAPIVersion;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getVerb() {
        return this.verb;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public boolean hasIsNonResourceURL() {
        return this.isNonResourceURL != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public boolean hasResourceAPIGroup() {
        return this.resourceAPIGroup != null;
    }

    public boolean hasResourceAPIVersion() {
        return this.resourceAPIVersion != null;
    }

    public boolean hasResourceName() {
        return this.resourceName != null;
    }

    public boolean hasVerb() {
        return this.verb != null;
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.content, this.isNonResourceURL, this.kind, this.metadata, this.namespace, this.path, this.resource, this.resourceAPIGroup, this.resourceAPIVersion, this.resourceName, this.verb, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.content != null) {
            sb.append("content:");
            sb.append(this.content);
            sb.append(",");
        }
        if (this.isNonResourceURL != null) {
            sb.append("isNonResourceURL:");
            sb.append(this.isNonResourceURL);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace);
            sb.append(",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path);
            sb.append(",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource);
            sb.append(",");
        }
        if (this.resourceAPIGroup != null) {
            sb.append("resourceAPIGroup:");
            sb.append(this.resourceAPIGroup);
            sb.append(",");
        }
        if (this.resourceAPIVersion != null) {
            sb.append("resourceAPIVersion:");
            sb.append(this.resourceAPIVersion);
            sb.append(",");
        }
        if (this.resourceName != null) {
            sb.append("resourceName:");
            sb.append(this.resourceName);
            sb.append(",");
        }
        if (this.verb != null) {
            sb.append("verb:");
            sb.append(this.verb);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withContent(Object content) {
        this.content = content;
        return (A)((Object)this);
    }

    public A withIsNonResourceURL() {
        return this.withIsNonResourceURL(true);
    }

    public A withIsNonResourceURL(Boolean isNonResourceURL) {
        this.isNonResourceURL = isNonResourceURL;
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public A withResource(String resource) {
        this.resource = resource;
        return (A)((Object)this);
    }

    public A withResourceAPIGroup(String resourceAPIGroup) {
        this.resourceAPIGroup = resourceAPIGroup;
        return (A)((Object)this);
    }

    public A withResourceAPIVersion(String resourceAPIVersion) {
        this.resourceAPIVersion = resourceAPIVersion;
        return (A)((Object)this);
    }

    public A withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return (A)((Object)this);
    }

    public A withVerb(String verb) {
        this.verb = verb;
        return (A)((Object)this);
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)LocalResourceAccessReviewFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

