/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.HubSource;
import io.fabric8.openshift.api.model.config.v1.HubSourceBuilder;
import io.fabric8.openshift.api.model.config.v1.HubSourceFluent;
import io.fabric8.openshift.api.model.config.v1.OperatorHubSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OperatorHubSpecFluent<A extends OperatorHubSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Boolean disableAllDefaultSources;
    private ArrayList<HubSourceBuilder> sources = new ArrayList();

    public OperatorHubSpecFluent() {
    }

    public OperatorHubSpecFluent(OperatorHubSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToSources(Collection<HubSource> items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (HubSource item : items) {
            HubSourceBuilder builder = new HubSourceBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)((Object)this);
    }

    public SourcesNested<A> addNewSource() {
        return new SourcesNested(-1, null);
    }

    public A addNewSource(Boolean disabled, String name) {
        return this.addToSources(new HubSource(disabled, name));
    }

    public SourcesNested<A> addNewSourceLike(HubSource item) {
        return new SourcesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSources(HubSource ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (HubSource item : items) {
            HubSourceBuilder builder = new HubSourceBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToSources(int index, HubSource item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        HubSourceBuilder builder = new HubSourceBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(index, builder);
        }
        return (A)((Object)this);
    }

    public HubSource buildFirstSource() {
        return this.sources.get(0).build();
    }

    public HubSource buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    public HubSource buildMatchingSource(Predicate<HubSourceBuilder> predicate) {
        for (HubSourceBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public HubSource buildSource(int index) {
        return this.sources.get(index).build();
    }

    public List<HubSource> buildSources() {
        return this.sources != null ? OperatorHubSpecFluent.build(this.sources) : null;
    }

    protected void copyInstance(OperatorHubSpec instance) {
        OperatorHubSpec operatorHubSpec = instance = instance != null ? instance : new OperatorHubSpec();
        if (instance != null) {
            this.withDisableAllDefaultSources(instance.getDisableAllDefaultSources());
            this.withSources(instance.getSources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "sources"));
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    public SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "sources"));
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editMatchingSource(Predicate<HubSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "sources"));
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editSource(int index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "sources"));
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OperatorHubSpecFluent that = (OperatorHubSpecFluent)((Object)o);
        if (!Objects.equals(this.disableAllDefaultSources, that.disableAllDefaultSources)) {
            return false;
        }
        if (!Objects.equals(this.sources, that.sources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getDisableAllDefaultSources() {
        return this.disableAllDefaultSources;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDisableAllDefaultSources() {
        return this.disableAllDefaultSources != null;
    }

    public boolean hasMatchingSource(Predicate<HubSourceBuilder> predicate) {
        for (HubSourceBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.disableAllDefaultSources, this.sources, this.additionalProperties);
    }

    public A removeAllFromSources(Collection<HubSource> items) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        for (HubSource item : items) {
            HubSourceBuilder builder = new HubSourceBuilder(item);
            this._visitables.get((Object)"sources").remove((Object)builder);
            this.sources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromSources(HubSource ... items) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        for (HubSource item : items) {
            HubSourceBuilder builder = new HubSourceBuilder(item);
            this._visitables.get((Object)"sources").remove((Object)builder);
            this.sources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSources(Predicate<HubSourceBuilder> predicate) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        Iterator<HubSourceBuilder> each = this.sources.iterator();
        List visitables = this._visitables.get((Object)"sources");
        while (each.hasNext()) {
            HubSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public SourcesNested<A> setNewSourceLike(int index, HubSource item) {
        return new SourcesNested(index, item);
    }

    public A setToSources(int index, HubSource item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        HubSourceBuilder builder = new HubSourceBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.disableAllDefaultSources != null) {
            sb.append("disableAllDefaultSources:");
            sb.append(this.disableAllDefaultSources);
            sb.append(",");
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            sb.append("sources:");
            sb.append(this.sources);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDisableAllDefaultSources() {
        return this.withDisableAllDefaultSources(true);
    }

    public A withDisableAllDefaultSources(Boolean disableAllDefaultSources) {
        this.disableAllDefaultSources = disableAllDefaultSources;
        return (A)((Object)this);
    }

    public A withSources(List<HubSource> sources) {
        if (this.sources != null) {
            this._visitables.get((Object)"sources").clear();
        }
        if (sources != null) {
            this.sources = new ArrayList();
            for (HubSource item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)((Object)this);
    }

    public A withSources(HubSource ... sources) {
        if (this.sources != null) {
            this.sources.clear();
            this._visitables.remove((Object)"sources");
        }
        if (sources != null) {
            for (HubSource item : sources) {
                this.addToSources(item);
            }
        }
        return (A)((Object)this);
    }

    public class SourcesNested<N>
    extends HubSourceFluent<SourcesNested<N>>
    implements Nested<N> {
        HubSourceBuilder builder;
        int index;

        SourcesNested(int index, HubSource item) {
            this.index = index;
            this.builder = new HubSourceBuilder(this, item);
        }

        public N and() {
            return (N)OperatorHubSpecFluent.this.setToSources(this.index, this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }
}

