package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RouteHTTPHeaderFluent<A extends io.fabric8.openshift.api.model.RouteHTTPHeaderFluent<A>> extends BaseFluent<A>{

  private RouteHTTPHeaderActionUnionBuilder action;
  private Map<String,Object> additionalProperties;
  private String name;

  public RouteHTTPHeaderFluent() {
  }
  
  public RouteHTTPHeaderFluent(RouteHTTPHeader instance) {
    this.copyInstance(instance);
  }

  public A addToAdditionalProperties(Map<String,Object> map) {
    if (this.additionalProperties == null && map != null) {
      this.additionalProperties = new LinkedHashMap();
    }
    if (map != null) {
      this.additionalProperties.putAll(map);
    }
    return (A) this;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if (this.additionalProperties == null && key != null && value != null) {
      this.additionalProperties = new LinkedHashMap();
    }
    if (key != null && value != null) {
      this.additionalProperties.put(key, value);
    }
    return (A) this;
  }
  
  public RouteHTTPHeaderActionUnion buildAction() {
    return this.action != null ? this.action.build() : null;
  }
  
  protected void copyInstance(RouteHTTPHeader instance) {
    instance = instance != null ? instance : new RouteHTTPHeader();
    if (instance != null) {
        this.withAction(instance.getAction());
        this.withName(instance.getName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  
  public ActionNested<A> editAction() {
    return this.withNewActionLike(Optional.ofNullable(this.buildAction()).orElse(null));
  }
  
  public ActionNested<A> editOrNewAction() {
    return this.withNewActionLike(Optional.ofNullable(this.buildAction()).orElse(new RouteHTTPHeaderActionUnionBuilder().build()));
  }
  
  public ActionNested<A> editOrNewActionLike(RouteHTTPHeaderActionUnion item) {
    return this.withNewActionLike(Optional.ofNullable(this.buildAction()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || this.getClass() != o.getClass()) {
      return false;
    }
    if (!(super.equals(o))) {
      return false;
    }
    RouteHTTPHeaderFluent that = (RouteHTTPHeaderFluent) o;
    if (!(Objects.equals(action, that.action))) {
      return false;
    }
    if (!(Objects.equals(name, that.name))) {
      return false;
    }
    if (!(Objects.equals(additionalProperties, that.additionalProperties))) {
      return false;
    }
    return true;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public String getName() {
    return this.name;
  }
  
  public boolean hasAction() {
    return this.action != null;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public int hashCode() {
    return Objects.hash(action, name, additionalProperties);
  }
  
  public A removeFromAdditionalProperties(String key) {
    if (this.additionalProperties == null) {
      return (A) this;
    }
    if (key != null && this.additionalProperties != null) {
      this.additionalProperties.remove(key);
    }
    return (A) this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if (this.additionalProperties == null) {
      return (A) this;
    }
    if (map != null) {
      for (Object key : map.keySet()) {
        if (this.additionalProperties != null) {
          this.additionalProperties.remove(key);
        }
      }
    }
    return (A) this;
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (!(action == null)) {
        sb.append("action:");
        sb.append(action);
        sb.append(",");
    }
    if (!(name == null)) {
        sb.append("name:");
        sb.append(name);
        sb.append(",");
    }
    if (!(additionalProperties == null) && !(additionalProperties.isEmpty())) {
        sb.append("additionalProperties:");
        sb.append(additionalProperties);
    }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAction(RouteHTTPHeaderActionUnion action) {
    this._visitables.remove("action");
    if (action != null) {
        this.action = new RouteHTTPHeaderActionUnionBuilder(action);
        this._visitables.get("action").add(this.action);
    } else {
        this.action = null;
        this._visitables.get("action").remove(this.action);
    }
    return (A) this;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public ActionNested<A> withNewAction() {
    return new ActionNested(null);
  }
  
  public ActionNested<A> withNewActionLike(RouteHTTPHeaderActionUnion item) {
    return new ActionNested(item);
  }
  public class ActionNested<N> extends RouteHTTPHeaderActionUnionFluent<ActionNested<N>> implements Nested<N>{
  
    RouteHTTPHeaderActionUnionBuilder builder;
  
    ActionNested(RouteHTTPHeaderActionUnion item) {
      this.builder = new RouteHTTPHeaderActionUnionBuilder(this, item);
    }
  
    public N and() {
      return (N) RouteHTTPHeaderFluent.this.withAction(builder.build());
    }
    
    public N endAction() {
      return and();
    }
    
  }
}