/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.AuditConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class AuditConfigFluent<A extends AuditConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String auditFilePath;
    private Boolean enabled;
    private String logFormat;
    private Integer maximumFileRetentionDays;
    private Integer maximumFileSizeMegabytes;
    private Integer maximumRetainedFiles;
    private Object policyConfiguration;
    private String policyFile;
    private String webHookKubeConfig;
    private String webHookMode;

    public AuditConfigFluent() {
    }

    public AuditConfigFluent(AuditConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    protected void copyInstance(AuditConfig instance) {
        AuditConfig auditConfig = instance = instance != null ? instance : new AuditConfig();
        if (instance != null) {
            this.withAuditFilePath(instance.getAuditFilePath());
            this.withEnabled(instance.getEnabled());
            this.withLogFormat(instance.getLogFormat());
            this.withMaximumFileRetentionDays(instance.getMaximumFileRetentionDays());
            this.withMaximumFileSizeMegabytes(instance.getMaximumFileSizeMegabytes());
            this.withMaximumRetainedFiles(instance.getMaximumRetainedFiles());
            this.withPolicyConfiguration(instance.getPolicyConfiguration());
            this.withPolicyFile(instance.getPolicyFile());
            this.withWebHookKubeConfig(instance.getWebHookKubeConfig());
            this.withWebHookMode(instance.getWebHookMode());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuditConfigFluent that = (AuditConfigFluent)((Object)o);
        if (!Objects.equals(this.auditFilePath, that.auditFilePath)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.logFormat, that.logFormat)) {
            return false;
        }
        if (!Objects.equals(this.maximumFileRetentionDays, that.maximumFileRetentionDays)) {
            return false;
        }
        if (!Objects.equals(this.maximumFileSizeMegabytes, that.maximumFileSizeMegabytes)) {
            return false;
        }
        if (!Objects.equals(this.maximumRetainedFiles, that.maximumRetainedFiles)) {
            return false;
        }
        if (!Objects.equals(this.policyConfiguration, that.policyConfiguration)) {
            return false;
        }
        if (!Objects.equals(this.policyFile, that.policyFile)) {
            return false;
        }
        if (!Objects.equals(this.webHookKubeConfig, that.webHookKubeConfig)) {
            return false;
        }
        if (!Objects.equals(this.webHookMode, that.webHookMode)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAuditFilePath() {
        return this.auditFilePath;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public Integer getMaximumFileRetentionDays() {
        return this.maximumFileRetentionDays;
    }

    public Integer getMaximumFileSizeMegabytes() {
        return this.maximumFileSizeMegabytes;
    }

    public Integer getMaximumRetainedFiles() {
        return this.maximumRetainedFiles;
    }

    public Object getPolicyConfiguration() {
        return this.policyConfiguration;
    }

    public String getPolicyFile() {
        return this.policyFile;
    }

    public String getWebHookKubeConfig() {
        return this.webHookKubeConfig;
    }

    public String getWebHookMode() {
        return this.webHookMode;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAuditFilePath() {
        return this.auditFilePath != null;
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public boolean hasLogFormat() {
        return this.logFormat != null;
    }

    public boolean hasMaximumFileRetentionDays() {
        return this.maximumFileRetentionDays != null;
    }

    public boolean hasMaximumFileSizeMegabytes() {
        return this.maximumFileSizeMegabytes != null;
    }

    public boolean hasMaximumRetainedFiles() {
        return this.maximumRetainedFiles != null;
    }

    public boolean hasPolicyConfiguration() {
        return this.policyConfiguration != null;
    }

    public boolean hasPolicyFile() {
        return this.policyFile != null;
    }

    public boolean hasWebHookKubeConfig() {
        return this.webHookKubeConfig != null;
    }

    public boolean hasWebHookMode() {
        return this.webHookMode != null;
    }

    public int hashCode() {
        return Objects.hash(this.auditFilePath, this.enabled, this.logFormat, this.maximumFileRetentionDays, this.maximumFileSizeMegabytes, this.maximumRetainedFiles, this.policyConfiguration, this.policyFile, this.webHookKubeConfig, this.webHookMode, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auditFilePath != null) {
            sb.append("auditFilePath:");
            sb.append(this.auditFilePath);
            sb.append(",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled);
            sb.append(",");
        }
        if (this.logFormat != null) {
            sb.append("logFormat:");
            sb.append(this.logFormat);
            sb.append(",");
        }
        if (this.maximumFileRetentionDays != null) {
            sb.append("maximumFileRetentionDays:");
            sb.append(this.maximumFileRetentionDays);
            sb.append(",");
        }
        if (this.maximumFileSizeMegabytes != null) {
            sb.append("maximumFileSizeMegabytes:");
            sb.append(this.maximumFileSizeMegabytes);
            sb.append(",");
        }
        if (this.maximumRetainedFiles != null) {
            sb.append("maximumRetainedFiles:");
            sb.append(this.maximumRetainedFiles);
            sb.append(",");
        }
        if (this.policyConfiguration != null) {
            sb.append("policyConfiguration:");
            sb.append(this.policyConfiguration);
            sb.append(",");
        }
        if (this.policyFile != null) {
            sb.append("policyFile:");
            sb.append(this.policyFile);
            sb.append(",");
        }
        if (this.webHookKubeConfig != null) {
            sb.append("webHookKubeConfig:");
            sb.append(this.webHookKubeConfig);
            sb.append(",");
        }
        if (this.webHookMode != null) {
            sb.append("webHookMode:");
            sb.append(this.webHookMode);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAuditFilePath(String auditFilePath) {
        this.auditFilePath = auditFilePath;
        return (A)((Object)this);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public A withLogFormat(String logFormat) {
        this.logFormat = logFormat;
        return (A)((Object)this);
    }

    public A withMaximumFileRetentionDays(Integer maximumFileRetentionDays) {
        this.maximumFileRetentionDays = maximumFileRetentionDays;
        return (A)((Object)this);
    }

    public A withMaximumFileSizeMegabytes(Integer maximumFileSizeMegabytes) {
        this.maximumFileSizeMegabytes = maximumFileSizeMegabytes;
        return (A)((Object)this);
    }

    public A withMaximumRetainedFiles(Integer maximumRetainedFiles) {
        this.maximumRetainedFiles = maximumRetainedFiles;
        return (A)((Object)this);
    }

    public A withPolicyConfiguration(Object policyConfiguration) {
        this.policyConfiguration = policyConfiguration;
        return (A)((Object)this);
    }

    public A withPolicyFile(String policyFile) {
        this.policyFile = policyFile;
        return (A)((Object)this);
    }

    public A withWebHookKubeConfig(String webHookKubeConfig) {
        this.webHookKubeConfig = webHookKubeConfig;
        return (A)((Object)this);
    }

    public A withWebHookMode(String webHookMode) {
        this.webHookMode = webHookMode;
        return (A)((Object)this);
    }
}

