package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceClassBuilder extends io.fabric8.servicecatalog.api.model.ServiceClassFluentImpl<io.fabric8.servicecatalog.api.model.ServiceClassBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.servicecatalog.api.model.ServiceClass,io.fabric8.servicecatalog.api.model.ServiceClassBuilder>{
  public ServiceClassBuilder() {
    this(false);
  }
  public ServiceClassBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceClass(), validationEnabled);
  }
  public ServiceClassBuilder(io.fabric8.servicecatalog.api.model.ServiceClassFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceClassBuilder(io.fabric8.servicecatalog.api.model.ServiceClassFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceClass(), validationEnabled);
  }
  public ServiceClassBuilder(io.fabric8.servicecatalog.api.model.ServiceClassFluent<?> fluent,io.fabric8.servicecatalog.api.model.ServiceClass instance) {
    this(fluent, instance, false);
  }
  public ServiceClassBuilder(io.fabric8.servicecatalog.api.model.ServiceClassFluent<?> fluent,io.fabric8.servicecatalog.api.model.ServiceClass instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceClassBuilder(io.fabric8.servicecatalog.api.model.ServiceClass instance) {
    this(instance,false);
  }
  public ServiceClassBuilder(io.fabric8.servicecatalog.api.model.ServiceClass instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.servicecatalog.api.model.ServiceClassFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.servicecatalog.api.model.ServiceClass build() {
    ServiceClass buildable = new ServiceClass(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceClassBuilder that = (ServiceClassBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}