package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceInstanceBuilder extends io.fabric8.servicecatalog.api.model.ServiceInstanceFluentImpl<io.fabric8.servicecatalog.api.model.ServiceInstanceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.servicecatalog.api.model.ServiceInstance,io.fabric8.servicecatalog.api.model.ServiceInstanceBuilder>{
  public ServiceInstanceBuilder() {
    this(false);
  }
  public ServiceInstanceBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceInstance(), validationEnabled);
  }
  public ServiceInstanceBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceInstanceBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceInstance(), validationEnabled);
  }
  public ServiceInstanceBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceFluent<?> fluent,io.fabric8.servicecatalog.api.model.ServiceInstance instance) {
    this(fluent, instance, false);
  }
  public ServiceInstanceBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceFluent<?> fluent,io.fabric8.servicecatalog.api.model.ServiceInstance instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceInstanceBuilder(io.fabric8.servicecatalog.api.model.ServiceInstance instance) {
    this(instance,false);
  }
  public ServiceInstanceBuilder(io.fabric8.servicecatalog.api.model.ServiceInstance instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.servicecatalog.api.model.ServiceInstanceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.servicecatalog.api.model.ServiceInstance build() {
    ServiceInstance buildable = new ServiceInstance(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceInstanceBuilder that = (ServiceInstanceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}