package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceInstanceListBuilder extends io.fabric8.servicecatalog.api.model.ServiceInstanceListFluentImpl<io.fabric8.servicecatalog.api.model.ServiceInstanceListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.servicecatalog.api.model.ServiceInstanceList,io.fabric8.servicecatalog.api.model.ServiceInstanceListBuilder>{
  public ServiceInstanceListBuilder() {
    this(false);
  }
  public ServiceInstanceListBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceInstanceList(), validationEnabled);
  }
  public ServiceInstanceListBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceInstanceListBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceInstanceList(), validationEnabled);
  }
  public ServiceInstanceListBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceListFluent<?> fluent,io.fabric8.servicecatalog.api.model.ServiceInstanceList instance) {
    this(fluent, instance, false);
  }
  public ServiceInstanceListBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceListFluent<?> fluent,io.fabric8.servicecatalog.api.model.ServiceInstanceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceInstanceListBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceList instance) {
    this(instance,false);
  }
  public ServiceInstanceListBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.servicecatalog.api.model.ServiceInstanceListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.servicecatalog.api.model.ServiceInstanceList build() {
    ServiceInstanceList buildable = new ServiceInstanceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceInstanceListBuilder that = (ServiceInstanceListBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}