package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceInstanceSpecBuilder extends io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl<io.fabric8.servicecatalog.api.model.ServiceInstanceSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.servicecatalog.api.model.ServiceInstanceSpec,io.fabric8.servicecatalog.api.model.ServiceInstanceSpecBuilder>{
  public ServiceInstanceSpecBuilder() {
    this(false);
  }
  public ServiceInstanceSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceInstanceSpec(), validationEnabled);
  }
  public ServiceInstanceSpecBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceInstanceSpecBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceInstanceSpec(), validationEnabled);
  }
  public ServiceInstanceSpecBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent<?> fluent,io.fabric8.servicecatalog.api.model.ServiceInstanceSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceInstanceSpecBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent<?> fluent,io.fabric8.servicecatalog.api.model.ServiceInstanceSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterServiceClassExternalID(instance.getClusterServiceClassExternalID()); 
    fluent.withClusterServiceClassExternalName(instance.getClusterServiceClassExternalName()); 
    fluent.withClusterServiceClassName(instance.getClusterServiceClassName()); 
    fluent.withClusterServiceClassRef(instance.getClusterServiceClassRef()); 
    fluent.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID()); 
    fluent.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName()); 
    fluent.withClusterServicePlanName(instance.getClusterServicePlanName()); 
    fluent.withClusterServicePlanRef(instance.getClusterServicePlanRef()); 
    fluent.withExternalID(instance.getExternalID()); 
    fluent.withParameters(instance.getParameters()); 
    fluent.withParametersFrom(instance.getParametersFrom()); 
    fluent.withServiceClassExternalID(instance.getServiceClassExternalID()); 
    fluent.withServiceClassExternalName(instance.getServiceClassExternalName()); 
    fluent.withServiceClassName(instance.getServiceClassName()); 
    fluent.withServiceClassRef(instance.getServiceClassRef()); 
    fluent.withServicePlanExternalID(instance.getServicePlanExternalID()); 
    fluent.withServicePlanExternalName(instance.getServicePlanExternalName()); 
    fluent.withServicePlanName(instance.getServicePlanName()); 
    fluent.withServicePlanRef(instance.getServicePlanRef()); 
    fluent.withUpdateRequests(instance.getUpdateRequests()); 
    fluent.withUserInfo(instance.getUserInfo()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceInstanceSpecBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceSpec instance) {
    this(instance,false);
  }
  public ServiceInstanceSpecBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterServiceClassExternalID(instance.getClusterServiceClassExternalID()); 
    this.withClusterServiceClassExternalName(instance.getClusterServiceClassExternalName()); 
    this.withClusterServiceClassName(instance.getClusterServiceClassName()); 
    this.withClusterServiceClassRef(instance.getClusterServiceClassRef()); 
    this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID()); 
    this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName()); 
    this.withClusterServicePlanName(instance.getClusterServicePlanName()); 
    this.withClusterServicePlanRef(instance.getClusterServicePlanRef()); 
    this.withExternalID(instance.getExternalID()); 
    this.withParameters(instance.getParameters()); 
    this.withParametersFrom(instance.getParametersFrom()); 
    this.withServiceClassExternalID(instance.getServiceClassExternalID()); 
    this.withServiceClassExternalName(instance.getServiceClassExternalName()); 
    this.withServiceClassName(instance.getServiceClassName()); 
    this.withServiceClassRef(instance.getServiceClassRef()); 
    this.withServicePlanExternalID(instance.getServicePlanExternalID()); 
    this.withServicePlanExternalName(instance.getServicePlanExternalName()); 
    this.withServicePlanName(instance.getServicePlanName()); 
    this.withServicePlanRef(instance.getServicePlanRef()); 
    this.withUpdateRequests(instance.getUpdateRequests()); 
    this.withUserInfo(instance.getUserInfo()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpec build() {
    ServiceInstanceSpec buildable = new ServiceInstanceSpec(fluent.getClusterServiceClassExternalID(),fluent.getClusterServiceClassExternalName(),fluent.getClusterServiceClassName(),fluent.getClusterServiceClassRef(),fluent.getClusterServicePlanExternalID(),fluent.getClusterServicePlanExternalName(),fluent.getClusterServicePlanName(),fluent.getClusterServicePlanRef(),fluent.getExternalID(),fluent.getParameters(),fluent.getParametersFrom(),fluent.getServiceClassExternalID(),fluent.getServiceClassExternalName(),fluent.getServiceClassName(),fluent.getServiceClassRef(),fluent.getServicePlanExternalID(),fluent.getServicePlanExternalName(),fluent.getServicePlanName(),fluent.getServicePlanRef(),fluent.getUpdateRequests(),fluent.getUserInfo());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceInstanceSpecBuilder that = (ServiceInstanceSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}