/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBrokerSpec;
import io.fabric8.servicecatalog.api.model.ServiceBrokerSpecFluent;
import io.fabric8.servicecatalog.api.model.ServiceBrokerSpecFluentImpl;
import java.util.Objects;

public class ServiceBrokerSpecBuilder
extends ServiceBrokerSpecFluentImpl<ServiceBrokerSpecBuilder>
implements VisitableBuilder<ServiceBrokerSpec, ServiceBrokerSpecBuilder> {
    ServiceBrokerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceBrokerSpecBuilder() {
        this(false);
    }

    public ServiceBrokerSpecBuilder(Boolean validationEnabled) {
        this(new ServiceBrokerSpec(), validationEnabled);
    }

    public ServiceBrokerSpecBuilder(ServiceBrokerSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServiceBrokerSpecBuilder(ServiceBrokerSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceBrokerSpec(), validationEnabled);
    }

    public ServiceBrokerSpecBuilder(ServiceBrokerSpecFluent<?> fluent, ServiceBrokerSpec instance) {
        this(fluent, instance, false);
    }

    public ServiceBrokerSpecBuilder(ServiceBrokerSpecFluent<?> fluent, ServiceBrokerSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAuthInfo(instance.getAuthInfo());
        fluent.withCaBundle(instance.getCaBundle());
        fluent.withCatalogRestrictions(instance.getCatalogRestrictions());
        fluent.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
        fluent.withRelistBehavior(instance.getRelistBehavior());
        fluent.withRelistDuration(instance.getRelistDuration());
        fluent.withRelistRequests(instance.getRelistRequests());
        fluent.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public ServiceBrokerSpecBuilder(ServiceBrokerSpec instance) {
        this(instance, (Boolean)false);
    }

    public ServiceBrokerSpecBuilder(ServiceBrokerSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAuthInfo(instance.getAuthInfo());
        this.withCaBundle(instance.getCaBundle());
        this.withCatalogRestrictions(instance.getCatalogRestrictions());
        this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
        this.withRelistBehavior(instance.getRelistBehavior());
        this.withRelistDuration(instance.getRelistDuration());
        this.withRelistRequests(instance.getRelistRequests());
        this.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public ServiceBrokerSpec build() {
        ServiceBrokerSpec buildable = new ServiceBrokerSpec(this.fluent.getAuthInfo(), this.fluent.getCaBundle(), this.fluent.getCatalogRestrictions(), this.fluent.getInsecureSkipTLSVerify(), this.fluent.getRelistBehavior(), this.fluent.getRelistDuration(), this.fluent.getRelistRequests(), this.fluent.getUrl());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBrokerSpecBuilder that = (ServiceBrokerSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

