package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterServicePlanSpecBuilder extends ClusterServicePlanSpecFluent<ClusterServicePlanSpecBuilder> implements VisitableBuilder<ClusterServicePlanSpec,ClusterServicePlanSpecBuilder>{
  public ClusterServicePlanSpecBuilder() {
    this(new ClusterServicePlanSpec());
  }
  
  public ClusterServicePlanSpecBuilder(ClusterServicePlanSpecFluent<?> fluent) {
    this(fluent, new ClusterServicePlanSpec());
  }
  
  public ClusterServicePlanSpecBuilder(ClusterServicePlanSpecFluent<?> fluent,ClusterServicePlanSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterServicePlanSpecBuilder(ClusterServicePlanSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterServicePlanSpecFluent<?> fluent;
  
  public ClusterServicePlanSpec build() {
    ClusterServicePlanSpec buildable = new ClusterServicePlanSpec(fluent.getBindable(),fluent.getClusterServiceBrokerName(),fluent.buildClusterServiceClassRef(),fluent.getDefaultProvisionParameters(),fluent.getDescription(),fluent.getExternalID(),fluent.getExternalMetadata(),fluent.getExternalName(),fluent.getFree(),fluent.getInstanceCreateParameterSchema(),fluent.getInstanceUpdateParameterSchema(),fluent.getServiceBindingCreateParameterSchema(),fluent.getServiceBindingCreateResponseSchema());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}