package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceInstancePropertiesStateBuilder extends ServiceInstancePropertiesStateFluent<ServiceInstancePropertiesStateBuilder> implements VisitableBuilder<ServiceInstancePropertiesState,ServiceInstancePropertiesStateBuilder>{
  public ServiceInstancePropertiesStateBuilder() {
    this(new ServiceInstancePropertiesState());
  }
  
  public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesStateFluent<?> fluent) {
    this(fluent, new ServiceInstancePropertiesState());
  }
  
  public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesStateFluent<?> fluent,ServiceInstancePropertiesState instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesState instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceInstancePropertiesStateFluent<?> fluent;
  
  public ServiceInstancePropertiesState build() {
    ServiceInstancePropertiesState buildable = new ServiceInstancePropertiesState(fluent.getClusterServicePlanExternalID(),fluent.getClusterServicePlanExternalName(),fluent.getParameterChecksum(),fluent.getParameters(),fluent.getServicePlanExternalID(),fluent.getServicePlanExternalName(),fluent.buildUserInfo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}