package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceBindingSpecBuilder extends ServiceBindingSpecFluent<ServiceBindingSpecBuilder> implements VisitableBuilder<ServiceBindingSpec,ServiceBindingSpecBuilder>{
  public ServiceBindingSpecBuilder() {
    this(new ServiceBindingSpec());
  }
  
  public ServiceBindingSpecBuilder(ServiceBindingSpecFluent<?> fluent) {
    this(fluent, new ServiceBindingSpec());
  }
  
  public ServiceBindingSpecBuilder(ServiceBindingSpecFluent<?> fluent,ServiceBindingSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceBindingSpecBuilder(ServiceBindingSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceBindingSpecFluent<?> fluent;
  
  public ServiceBindingSpec build() {
    ServiceBindingSpec buildable = new ServiceBindingSpec(fluent.getExternalID(),fluent.buildInstanceRef(),fluent.getParameters(),fluent.buildParametersFrom(),fluent.getSecretName(),fluent.buildSecretTransforms(),fluent.buildUserInfo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}