package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterServiceBrokerSpecFluentImpl<A extends ClusterServiceBrokerSpecFluent<A>> extends BaseFluent<A> implements ClusterServiceBrokerSpecFluent<A>{
  public ClusterServiceBrokerSpecFluentImpl() {
  }
  public ClusterServiceBrokerSpecFluentImpl(ClusterServiceBrokerSpec instance) {
    this.withAuthInfo(instance.getAuthInfo()); 
    this.withCaBundle(instance.getCaBundle()); 
    this.withCatalogRestrictions(instance.getCatalogRestrictions()); 
    this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify()); 
    this.withRelistBehavior(instance.getRelistBehavior()); 
    this.withRelistDuration(instance.getRelistDuration()); 
    this.withRelistRequests(instance.getRelistRequests()); 
    this.withUrl(instance.getUrl()); 
  }
  private ClusterServiceBrokerAuthInfoBuilder authInfo;
  private String caBundle;
  private CatalogRestrictionsBuilder catalogRestrictions;
  private Boolean insecureSkipTLSVerify;
  private String relistBehavior;
  private Duration relistDuration;
  private Long relistRequests;
  private String url;
  
  /**
   * This method has been deprecated, please use method buildAuthInfo instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterServiceBrokerAuthInfo getAuthInfo() {
    return this.authInfo!=null ?this.authInfo.build():null;
  }
  public ClusterServiceBrokerAuthInfo buildAuthInfo() {
    return this.authInfo!=null ?this.authInfo.build():null;
  }
  public A withAuthInfo(ClusterServiceBrokerAuthInfo authInfo) {
    _visitables.get("authInfo").remove(this.authInfo);
    if (authInfo!=null){ this.authInfo= new ClusterServiceBrokerAuthInfoBuilder(authInfo); _visitables.get("authInfo").add(this.authInfo);} else { this.authInfo = null; _visitables.get("authInfo").remove(this.authInfo); } return (A) this;
  }
  public Boolean hasAuthInfo() {
    return this.authInfo != null;
  }
  public ClusterServiceBrokerSpecFluent.AuthInfoNested<A> withNewAuthInfo() {
    return new ClusterServiceBrokerSpecFluentImpl.AuthInfoNestedImpl();
  }
  public ClusterServiceBrokerSpecFluent.AuthInfoNested<A> withNewAuthInfoLike(ClusterServiceBrokerAuthInfo item) {
    return new ClusterServiceBrokerSpecFluentImpl.AuthInfoNestedImpl(item);
  }
  public ClusterServiceBrokerSpecFluent.AuthInfoNested<A> editAuthInfo() {
    return withNewAuthInfoLike(getAuthInfo());
  }
  public ClusterServiceBrokerSpecFluent.AuthInfoNested<A> editOrNewAuthInfo() {
    return withNewAuthInfoLike(getAuthInfo() != null ? getAuthInfo(): new ClusterServiceBrokerAuthInfoBuilder().build());
  }
  public ClusterServiceBrokerSpecFluent.AuthInfoNested<A> editOrNewAuthInfoLike(ClusterServiceBrokerAuthInfo item) {
    return withNewAuthInfoLike(getAuthInfo() != null ? getAuthInfo(): item);
  }
  public String getCaBundle() {
    return this.caBundle;
  }
  public A withCaBundle(String caBundle) {
    this.caBundle=caBundle; return (A) this;
  }
  public Boolean hasCaBundle() {
    return this.caBundle != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCatalogRestrictions instead.
   * @return The buildable object.
   */
  @Deprecated
  public CatalogRestrictions getCatalogRestrictions() {
    return this.catalogRestrictions!=null ?this.catalogRestrictions.build():null;
  }
  public CatalogRestrictions buildCatalogRestrictions() {
    return this.catalogRestrictions!=null ?this.catalogRestrictions.build():null;
  }
  public A withCatalogRestrictions(CatalogRestrictions catalogRestrictions) {
    _visitables.get("catalogRestrictions").remove(this.catalogRestrictions);
    if (catalogRestrictions!=null){ this.catalogRestrictions= new CatalogRestrictionsBuilder(catalogRestrictions); _visitables.get("catalogRestrictions").add(this.catalogRestrictions);} else { this.catalogRestrictions = null; _visitables.get("catalogRestrictions").remove(this.catalogRestrictions); } return (A) this;
  }
  public Boolean hasCatalogRestrictions() {
    return this.catalogRestrictions != null;
  }
  public ClusterServiceBrokerSpecFluent.CatalogRestrictionsNested<A> withNewCatalogRestrictions() {
    return new ClusterServiceBrokerSpecFluentImpl.CatalogRestrictionsNestedImpl();
  }
  public ClusterServiceBrokerSpecFluent.CatalogRestrictionsNested<A> withNewCatalogRestrictionsLike(CatalogRestrictions item) {
    return new ClusterServiceBrokerSpecFluentImpl.CatalogRestrictionsNestedImpl(item);
  }
  public ClusterServiceBrokerSpecFluent.CatalogRestrictionsNested<A> editCatalogRestrictions() {
    return withNewCatalogRestrictionsLike(getCatalogRestrictions());
  }
  public ClusterServiceBrokerSpecFluent.CatalogRestrictionsNested<A> editOrNewCatalogRestrictions() {
    return withNewCatalogRestrictionsLike(getCatalogRestrictions() != null ? getCatalogRestrictions(): new CatalogRestrictionsBuilder().build());
  }
  public ClusterServiceBrokerSpecFluent.CatalogRestrictionsNested<A> editOrNewCatalogRestrictionsLike(CatalogRestrictions item) {
    return withNewCatalogRestrictionsLike(getCatalogRestrictions() != null ? getCatalogRestrictions(): item);
  }
  public Boolean getInsecureSkipTLSVerify() {
    return this.insecureSkipTLSVerify;
  }
  public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
    this.insecureSkipTLSVerify=insecureSkipTLSVerify; return (A) this;
  }
  public Boolean hasInsecureSkipTLSVerify() {
    return this.insecureSkipTLSVerify != null;
  }
  public String getRelistBehavior() {
    return this.relistBehavior;
  }
  public A withRelistBehavior(String relistBehavior) {
    this.relistBehavior=relistBehavior; return (A) this;
  }
  public Boolean hasRelistBehavior() {
    return this.relistBehavior != null;
  }
  public Duration getRelistDuration() {
    return this.relistDuration;
  }
  public A withRelistDuration(Duration relistDuration) {
    this.relistDuration=relistDuration; return (A) this;
  }
  public Boolean hasRelistDuration() {
    return this.relistDuration != null;
  }
  public Long getRelistRequests() {
    return this.relistRequests;
  }
  public A withRelistRequests(Long relistRequests) {
    this.relistRequests=relistRequests; return (A) this;
  }
  public Boolean hasRelistRequests() {
    return this.relistRequests != null;
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterServiceBrokerSpecFluentImpl that = (ClusterServiceBrokerSpecFluentImpl) o;
    if (authInfo != null ? !authInfo.equals(that.authInfo) :that.authInfo != null) return false;
    if (caBundle != null ? !caBundle.equals(that.caBundle) :that.caBundle != null) return false;
    if (catalogRestrictions != null ? !catalogRestrictions.equals(that.catalogRestrictions) :that.catalogRestrictions != null) return false;
    if (insecureSkipTLSVerify != null ? !insecureSkipTLSVerify.equals(that.insecureSkipTLSVerify) :that.insecureSkipTLSVerify != null) return false;
    if (relistBehavior != null ? !relistBehavior.equals(that.relistBehavior) :that.relistBehavior != null) return false;
    if (relistDuration != null ? !relistDuration.equals(that.relistDuration) :that.relistDuration != null) return false;
    if (relistRequests != null ? !relistRequests.equals(that.relistRequests) :that.relistRequests != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authInfo,  caBundle,  catalogRestrictions,  insecureSkipTLSVerify,  relistBehavior,  relistDuration,  relistRequests,  url,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authInfo != null) { sb.append("authInfo:"); sb.append(authInfo + ","); }
    if (caBundle != null) { sb.append("caBundle:"); sb.append(caBundle + ","); }
    if (catalogRestrictions != null) { sb.append("catalogRestrictions:"); sb.append(catalogRestrictions + ","); }
    if (insecureSkipTLSVerify != null) { sb.append("insecureSkipTLSVerify:"); sb.append(insecureSkipTLSVerify + ","); }
    if (relistBehavior != null) { sb.append("relistBehavior:"); sb.append(relistBehavior + ","); }
    if (relistDuration != null) { sb.append("relistDuration:"); sb.append(relistDuration + ","); }
    if (relistRequests != null) { sb.append("relistRequests:"); sb.append(relistRequests + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  public A withInsecureSkipTLSVerify() {
    return withInsecureSkipTLSVerify(true);
  }
  class AuthInfoNestedImpl<N> extends ClusterServiceBrokerAuthInfoFluentImpl<ClusterServiceBrokerSpecFluent.AuthInfoNested<N>> implements ClusterServiceBrokerSpecFluent.AuthInfoNested<N>,Nested<N>{
    AuthInfoNestedImpl(ClusterServiceBrokerAuthInfo item) {
      this.builder = new ClusterServiceBrokerAuthInfoBuilder(this, item);
    }
    AuthInfoNestedImpl() {
      this.builder = new ClusterServiceBrokerAuthInfoBuilder(this);
    }
    ClusterServiceBrokerAuthInfoBuilder builder;
    public N and() {
      return (N) ClusterServiceBrokerSpecFluentImpl.this.withAuthInfo(builder.build());
    }
    public N endAuthInfo() {
      return and();
    }
    
  }
  class CatalogRestrictionsNestedImpl<N> extends CatalogRestrictionsFluentImpl<ClusterServiceBrokerSpecFluent.CatalogRestrictionsNested<N>> implements ClusterServiceBrokerSpecFluent.CatalogRestrictionsNested<N>,Nested<N>{
    CatalogRestrictionsNestedImpl(CatalogRestrictions item) {
      this.builder = new CatalogRestrictionsBuilder(this, item);
    }
    CatalogRestrictionsNestedImpl() {
      this.builder = new CatalogRestrictionsBuilder(this);
    }
    CatalogRestrictionsBuilder builder;
    public N and() {
      return (N) ClusterServiceBrokerSpecFluentImpl.this.withCatalogRestrictions(builder.build());
    }
    public N endCatalogRestrictions() {
      return and();
    }
    
  }
  
}