package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServicePlanSpecBuilder extends ClusterServicePlanSpecFluentImpl<ClusterServicePlanSpecBuilder> implements VisitableBuilder<ClusterServicePlanSpec,ClusterServicePlanSpecBuilder>{
  public ClusterServicePlanSpecBuilder() {
    this(false);
  }
  public ClusterServicePlanSpecBuilder(Boolean validationEnabled) {
    this(new ClusterServicePlanSpec(), validationEnabled);
  }
  public ClusterServicePlanSpecBuilder(ClusterServicePlanSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServicePlanSpecBuilder(ClusterServicePlanSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServicePlanSpec(), validationEnabled);
  }
  public ClusterServicePlanSpecBuilder(ClusterServicePlanSpecFluent<?> fluent,ClusterServicePlanSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterServicePlanSpecBuilder(ClusterServicePlanSpecFluent<?> fluent,ClusterServicePlanSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBindable(instance.getBindable()); 
    fluent.withClusterServiceBrokerName(instance.getClusterServiceBrokerName()); 
    fluent.withClusterServiceClassRef(instance.getClusterServiceClassRef()); 
    fluent.withDefaultProvisionParameters(instance.getDefaultProvisionParameters()); 
    fluent.withDescription(instance.getDescription()); 
    fluent.withExternalID(instance.getExternalID()); 
    fluent.withExternalMetadata(instance.getExternalMetadata()); 
    fluent.withExternalName(instance.getExternalName()); 
    fluent.withFree(instance.getFree()); 
    fluent.withInstanceCreateParameterSchema(instance.getInstanceCreateParameterSchema()); 
    fluent.withInstanceUpdateParameterSchema(instance.getInstanceUpdateParameterSchema()); 
    fluent.withServiceBindingCreateParameterSchema(instance.getServiceBindingCreateParameterSchema()); 
    fluent.withServiceBindingCreateResponseSchema(instance.getServiceBindingCreateResponseSchema()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServicePlanSpecBuilder(ClusterServicePlanSpec instance) {
    this(instance,false);
  }
  public ClusterServicePlanSpecBuilder(ClusterServicePlanSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBindable(instance.getBindable()); 
    this.withClusterServiceBrokerName(instance.getClusterServiceBrokerName()); 
    this.withClusterServiceClassRef(instance.getClusterServiceClassRef()); 
    this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters()); 
    this.withDescription(instance.getDescription()); 
    this.withExternalID(instance.getExternalID()); 
    this.withExternalMetadata(instance.getExternalMetadata()); 
    this.withExternalName(instance.getExternalName()); 
    this.withFree(instance.getFree()); 
    this.withInstanceCreateParameterSchema(instance.getInstanceCreateParameterSchema()); 
    this.withInstanceUpdateParameterSchema(instance.getInstanceUpdateParameterSchema()); 
    this.withServiceBindingCreateParameterSchema(instance.getServiceBindingCreateParameterSchema()); 
    this.withServiceBindingCreateResponseSchema(instance.getServiceBindingCreateResponseSchema()); 
    this.validationEnabled = validationEnabled; 
  }
  ClusterServicePlanSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServicePlanSpec build() {
    ClusterServicePlanSpec buildable = new ClusterServicePlanSpec(fluent.getBindable(),fluent.getClusterServiceBrokerName(),fluent.getClusterServiceClassRef(),fluent.getDefaultProvisionParameters(),fluent.getDescription(),fluent.getExternalID(),fluent.getExternalMetadata(),fluent.getExternalName(),fluent.getFree(),fluent.getInstanceCreateParameterSchema(),fluent.getInstanceUpdateParameterSchema(),fluent.getServiceBindingCreateParameterSchema(),fluent.getServiceBindingCreateResponseSchema());
    return buildable;
  }
  
}