package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceClassListBuilder extends ServiceClassListFluentImpl<ServiceClassListBuilder> implements VisitableBuilder<ServiceClassList,ServiceClassListBuilder>{
  public ServiceClassListBuilder() {
    this(false);
  }
  public ServiceClassListBuilder(Boolean validationEnabled) {
    this(new ServiceClassList(), validationEnabled);
  }
  public ServiceClassListBuilder(ServiceClassListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceClassListBuilder(ServiceClassListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceClassList(), validationEnabled);
  }
  public ServiceClassListBuilder(ServiceClassListFluent<?> fluent,ServiceClassList instance) {
    this(fluent, instance, false);
  }
  public ServiceClassListBuilder(ServiceClassListFluent<?> fluent,ServiceClassList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceClassListBuilder(ServiceClassList instance) {
    this(instance,false);
  }
  public ServiceClassListBuilder(ServiceClassList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceClassListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceClassList build() {
    ServiceClassList buildable = new ServiceClassList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}