package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceBindingStatusFluentImpl<A extends ServiceBindingStatusFluent<A>> extends BaseFluent<A> implements ServiceBindingStatusFluent<A>{
  public ServiceBindingStatusFluentImpl() {
  }
  public ServiceBindingStatusFluentImpl(ServiceBindingStatus instance) {
    this.withAsyncOpInProgress(instance.getAsyncOpInProgress()); 
    this.withConditions(instance.getConditions()); 
    this.withCurrentOperation(instance.getCurrentOperation()); 
    this.withExternalProperties(instance.getExternalProperties()); 
    this.withInProgressProperties(instance.getInProgressProperties()); 
    this.withLastOperation(instance.getLastOperation()); 
    this.withOperationStartTime(instance.getOperationStartTime()); 
    this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress()); 
    this.withReconciledGeneration(instance.getReconciledGeneration()); 
    this.withUnbindStatus(instance.getUnbindStatus()); 
  }
  private Boolean asyncOpInProgress;
  private ArrayList<ServiceBindingConditionBuilder> conditions = new ArrayList<ServiceBindingConditionBuilder>();
  private String currentOperation;
  private ServiceBindingPropertiesStateBuilder externalProperties;
  private ServiceBindingPropertiesStateBuilder inProgressProperties;
  private String lastOperation;
  private String operationStartTime;
  private Boolean orphanMitigationInProgress;
  private Long reconciledGeneration;
  private String unbindStatus;
  public Boolean getAsyncOpInProgress() {
    return this.asyncOpInProgress;
  }
  public A withAsyncOpInProgress(Boolean asyncOpInProgress) {
    this.asyncOpInProgress=asyncOpInProgress; return (A) this;
  }
  public Boolean hasAsyncOpInProgress() {
    return this.asyncOpInProgress != null;
  }
  public A addToConditions(Integer index,ServiceBindingCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,ServiceBindingCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.servicecatalog.api.model.ServiceBindingCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ServiceBindingCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.servicecatalog.api.model.ServiceBindingCondition... items) {
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ServiceBindingCondition> items) {
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ServiceBindingConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ServiceBindingConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ServiceBindingConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceBindingCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ServiceBindingCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ServiceBindingCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public ServiceBindingCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ServiceBindingCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ServiceBindingCondition buildMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
    for (ServiceBindingConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
    for (ServiceBindingConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ServiceBindingCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (ServiceBindingCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.servicecatalog.api.model.ServiceBindingCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (ServiceBindingCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ServiceBindingCondition(lastTransitionTime, message, reason, status, type));
  }
  public ServiceBindingStatusFluent.ConditionsNested<A> addNewCondition() {
    return new ServiceBindingStatusFluentImpl.ConditionsNestedImpl();
  }
  public ServiceBindingStatusFluent.ConditionsNested<A> addNewConditionLike(ServiceBindingCondition item) {
    return new ServiceBindingStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ServiceBindingStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,ServiceBindingCondition item) {
    return new ServiceBindingStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ServiceBindingStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ServiceBindingStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ServiceBindingStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ServiceBindingStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getCurrentOperation() {
    return this.currentOperation;
  }
  public A withCurrentOperation(String currentOperation) {
    this.currentOperation=currentOperation; return (A) this;
  }
  public Boolean hasCurrentOperation() {
    return this.currentOperation != null;
  }
  
  /**
   * This method has been deprecated, please use method buildExternalProperties instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceBindingPropertiesState getExternalProperties() {
    return this.externalProperties!=null ?this.externalProperties.build():null;
  }
  public ServiceBindingPropertiesState buildExternalProperties() {
    return this.externalProperties!=null ?this.externalProperties.build():null;
  }
  public A withExternalProperties(ServiceBindingPropertiesState externalProperties) {
    _visitables.get("externalProperties").remove(this.externalProperties);
    if (externalProperties!=null){ this.externalProperties= new ServiceBindingPropertiesStateBuilder(externalProperties); _visitables.get("externalProperties").add(this.externalProperties);} else { this.externalProperties = null; _visitables.get("externalProperties").remove(this.externalProperties); } return (A) this;
  }
  public Boolean hasExternalProperties() {
    return this.externalProperties != null;
  }
  public ServiceBindingStatusFluent.ExternalPropertiesNested<A> withNewExternalProperties() {
    return new ServiceBindingStatusFluentImpl.ExternalPropertiesNestedImpl();
  }
  public ServiceBindingStatusFluent.ExternalPropertiesNested<A> withNewExternalPropertiesLike(ServiceBindingPropertiesState item) {
    return new ServiceBindingStatusFluentImpl.ExternalPropertiesNestedImpl(item);
  }
  public ServiceBindingStatusFluent.ExternalPropertiesNested<A> editExternalProperties() {
    return withNewExternalPropertiesLike(getExternalProperties());
  }
  public ServiceBindingStatusFluent.ExternalPropertiesNested<A> editOrNewExternalProperties() {
    return withNewExternalPropertiesLike(getExternalProperties() != null ? getExternalProperties(): new ServiceBindingPropertiesStateBuilder().build());
  }
  public ServiceBindingStatusFluent.ExternalPropertiesNested<A> editOrNewExternalPropertiesLike(ServiceBindingPropertiesState item) {
    return withNewExternalPropertiesLike(getExternalProperties() != null ? getExternalProperties(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildInProgressProperties instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceBindingPropertiesState getInProgressProperties() {
    return this.inProgressProperties!=null ?this.inProgressProperties.build():null;
  }
  public ServiceBindingPropertiesState buildInProgressProperties() {
    return this.inProgressProperties!=null ?this.inProgressProperties.build():null;
  }
  public A withInProgressProperties(ServiceBindingPropertiesState inProgressProperties) {
    _visitables.get("inProgressProperties").remove(this.inProgressProperties);
    if (inProgressProperties!=null){ this.inProgressProperties= new ServiceBindingPropertiesStateBuilder(inProgressProperties); _visitables.get("inProgressProperties").add(this.inProgressProperties);} else { this.inProgressProperties = null; _visitables.get("inProgressProperties").remove(this.inProgressProperties); } return (A) this;
  }
  public Boolean hasInProgressProperties() {
    return this.inProgressProperties != null;
  }
  public ServiceBindingStatusFluent.InProgressPropertiesNested<A> withNewInProgressProperties() {
    return new ServiceBindingStatusFluentImpl.InProgressPropertiesNestedImpl();
  }
  public ServiceBindingStatusFluent.InProgressPropertiesNested<A> withNewInProgressPropertiesLike(ServiceBindingPropertiesState item) {
    return new ServiceBindingStatusFluentImpl.InProgressPropertiesNestedImpl(item);
  }
  public ServiceBindingStatusFluent.InProgressPropertiesNested<A> editInProgressProperties() {
    return withNewInProgressPropertiesLike(getInProgressProperties());
  }
  public ServiceBindingStatusFluent.InProgressPropertiesNested<A> editOrNewInProgressProperties() {
    return withNewInProgressPropertiesLike(getInProgressProperties() != null ? getInProgressProperties(): new ServiceBindingPropertiesStateBuilder().build());
  }
  public ServiceBindingStatusFluent.InProgressPropertiesNested<A> editOrNewInProgressPropertiesLike(ServiceBindingPropertiesState item) {
    return withNewInProgressPropertiesLike(getInProgressProperties() != null ? getInProgressProperties(): item);
  }
  public String getLastOperation() {
    return this.lastOperation;
  }
  public A withLastOperation(String lastOperation) {
    this.lastOperation=lastOperation; return (A) this;
  }
  public Boolean hasLastOperation() {
    return this.lastOperation != null;
  }
  public String getOperationStartTime() {
    return this.operationStartTime;
  }
  public A withOperationStartTime(String operationStartTime) {
    this.operationStartTime=operationStartTime; return (A) this;
  }
  public Boolean hasOperationStartTime() {
    return this.operationStartTime != null;
  }
  public Boolean getOrphanMitigationInProgress() {
    return this.orphanMitigationInProgress;
  }
  public A withOrphanMitigationInProgress(Boolean orphanMitigationInProgress) {
    this.orphanMitigationInProgress=orphanMitigationInProgress; return (A) this;
  }
  public Boolean hasOrphanMitigationInProgress() {
    return this.orphanMitigationInProgress != null;
  }
  public Long getReconciledGeneration() {
    return this.reconciledGeneration;
  }
  public A withReconciledGeneration(Long reconciledGeneration) {
    this.reconciledGeneration=reconciledGeneration; return (A) this;
  }
  public Boolean hasReconciledGeneration() {
    return this.reconciledGeneration != null;
  }
  public String getUnbindStatus() {
    return this.unbindStatus;
  }
  public A withUnbindStatus(String unbindStatus) {
    this.unbindStatus=unbindStatus; return (A) this;
  }
  public Boolean hasUnbindStatus() {
    return this.unbindStatus != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceBindingStatusFluentImpl that = (ServiceBindingStatusFluentImpl) o;
    if (asyncOpInProgress != null ? !asyncOpInProgress.equals(that.asyncOpInProgress) :that.asyncOpInProgress != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (currentOperation != null ? !currentOperation.equals(that.currentOperation) :that.currentOperation != null) return false;
    if (externalProperties != null ? !externalProperties.equals(that.externalProperties) :that.externalProperties != null) return false;
    if (inProgressProperties != null ? !inProgressProperties.equals(that.inProgressProperties) :that.inProgressProperties != null) return false;
    if (lastOperation != null ? !lastOperation.equals(that.lastOperation) :that.lastOperation != null) return false;
    if (operationStartTime != null ? !operationStartTime.equals(that.operationStartTime) :that.operationStartTime != null) return false;
    if (orphanMitigationInProgress != null ? !orphanMitigationInProgress.equals(that.orphanMitigationInProgress) :that.orphanMitigationInProgress != null) return false;
    if (reconciledGeneration != null ? !reconciledGeneration.equals(that.reconciledGeneration) :that.reconciledGeneration != null) return false;
    if (unbindStatus != null ? !unbindStatus.equals(that.unbindStatus) :that.unbindStatus != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(asyncOpInProgress,  conditions,  currentOperation,  externalProperties,  inProgressProperties,  lastOperation,  operationStartTime,  orphanMitigationInProgress,  reconciledGeneration,  unbindStatus,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (asyncOpInProgress != null) { sb.append("asyncOpInProgress:"); sb.append(asyncOpInProgress + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentOperation != null) { sb.append("currentOperation:"); sb.append(currentOperation + ","); }
    if (externalProperties != null) { sb.append("externalProperties:"); sb.append(externalProperties + ","); }
    if (inProgressProperties != null) { sb.append("inProgressProperties:"); sb.append(inProgressProperties + ","); }
    if (lastOperation != null) { sb.append("lastOperation:"); sb.append(lastOperation + ","); }
    if (operationStartTime != null) { sb.append("operationStartTime:"); sb.append(operationStartTime + ","); }
    if (orphanMitigationInProgress != null) { sb.append("orphanMitigationInProgress:"); sb.append(orphanMitigationInProgress + ","); }
    if (reconciledGeneration != null) { sb.append("reconciledGeneration:"); sb.append(reconciledGeneration + ","); }
    if (unbindStatus != null) { sb.append("unbindStatus:"); sb.append(unbindStatus); }
    sb.append("}");
    return sb.toString();
  }
  public A withAsyncOpInProgress() {
    return withAsyncOpInProgress(true);
  }
  public A withOrphanMitigationInProgress() {
    return withOrphanMitigationInProgress(true);
  }
  class ConditionsNestedImpl<N> extends ServiceBindingConditionFluentImpl<ServiceBindingStatusFluent.ConditionsNested<N>> implements ServiceBindingStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,ServiceBindingCondition item) {
      this.index = index;
      this.builder = new ServiceBindingConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceBindingConditionBuilder(this);
    }
    ServiceBindingConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ServiceBindingStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ExternalPropertiesNestedImpl<N> extends ServiceBindingPropertiesStateFluentImpl<ServiceBindingStatusFluent.ExternalPropertiesNested<N>> implements ServiceBindingStatusFluent.ExternalPropertiesNested<N>,Nested<N>{
    ExternalPropertiesNestedImpl(ServiceBindingPropertiesState item) {
      this.builder = new ServiceBindingPropertiesStateBuilder(this, item);
    }
    ExternalPropertiesNestedImpl() {
      this.builder = new ServiceBindingPropertiesStateBuilder(this);
    }
    ServiceBindingPropertiesStateBuilder builder;
    public N and() {
      return (N) ServiceBindingStatusFluentImpl.this.withExternalProperties(builder.build());
    }
    public N endExternalProperties() {
      return and();
    }
    
  }
  class InProgressPropertiesNestedImpl<N> extends ServiceBindingPropertiesStateFluentImpl<ServiceBindingStatusFluent.InProgressPropertiesNested<N>> implements ServiceBindingStatusFluent.InProgressPropertiesNested<N>,Nested<N>{
    InProgressPropertiesNestedImpl(ServiceBindingPropertiesState item) {
      this.builder = new ServiceBindingPropertiesStateBuilder(this, item);
    }
    InProgressPropertiesNestedImpl() {
      this.builder = new ServiceBindingPropertiesStateBuilder(this);
    }
    ServiceBindingPropertiesStateBuilder builder;
    public N and() {
      return (N) ServiceBindingStatusFluentImpl.this.withInProgressProperties(builder.build());
    }
    public N endInProgressProperties() {
      return and();
    }
    
  }
  
}