package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBrokerSpecBuilder extends ServiceBrokerSpecFluentImpl<ServiceBrokerSpecBuilder> implements VisitableBuilder<ServiceBrokerSpec,ServiceBrokerSpecBuilder>{
  public ServiceBrokerSpecBuilder() {
    this(false);
  }
  public ServiceBrokerSpecBuilder(Boolean validationEnabled) {
    this(new ServiceBrokerSpec(), validationEnabled);
  }
  public ServiceBrokerSpecBuilder(ServiceBrokerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBrokerSpecBuilder(ServiceBrokerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBrokerSpec(), validationEnabled);
  }
  public ServiceBrokerSpecBuilder(ServiceBrokerSpecFluent<?> fluent,ServiceBrokerSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceBrokerSpecBuilder(ServiceBrokerSpecFluent<?> fluent,ServiceBrokerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthInfo(instance.getAuthInfo()); 
    fluent.withCaBundle(instance.getCaBundle()); 
    fluent.withCatalogRestrictions(instance.getCatalogRestrictions()); 
    fluent.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify()); 
    fluent.withRelistBehavior(instance.getRelistBehavior()); 
    fluent.withRelistDuration(instance.getRelistDuration()); 
    fluent.withRelistRequests(instance.getRelistRequests()); 
    fluent.withUrl(instance.getUrl()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBrokerSpecBuilder(ServiceBrokerSpec instance) {
    this(instance,false);
  }
  public ServiceBrokerSpecBuilder(ServiceBrokerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthInfo(instance.getAuthInfo()); 
    this.withCaBundle(instance.getCaBundle()); 
    this.withCatalogRestrictions(instance.getCatalogRestrictions()); 
    this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify()); 
    this.withRelistBehavior(instance.getRelistBehavior()); 
    this.withRelistDuration(instance.getRelistDuration()); 
    this.withRelistRequests(instance.getRelistRequests()); 
    this.withUrl(instance.getUrl()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceBrokerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBrokerSpec build() {
    ServiceBrokerSpec buildable = new ServiceBrokerSpec(fluent.getAuthInfo(),fluent.getCaBundle(),fluent.getCatalogRestrictions(),fluent.getInsecureSkipTLSVerify(),fluent.getRelistBehavior(),fluent.getRelistDuration(),fluent.getRelistRequests(),fluent.getUrl());
    return buildable;
  }
  
}