package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface ServiceInstanceListFluent<A extends ServiceInstanceListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,ServiceInstance item);
  public A setToItems(Integer index,ServiceInstance item);
  public A addToItems(io.fabric8.servicecatalog.api.model.ServiceInstance... items);
  public A addAllToItems(Collection<ServiceInstance> items);
  public A removeFromItems(io.fabric8.servicecatalog.api.model.ServiceInstance... items);
  public A removeAllFromItems(Collection<ServiceInstance> items);
  public A removeMatchingFromItems(Predicate<ServiceInstanceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceInstance> getItems();
  public List<ServiceInstance> buildItems();
  public ServiceInstance buildItem(Integer index);
  public ServiceInstance buildFirstItem();
  public ServiceInstance buildLastItem();
  public ServiceInstance buildMatchingItem(Predicate<ServiceInstanceBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ServiceInstanceBuilder> predicate);
  public A withItems(List<ServiceInstance> items);
  public A withItems(io.fabric8.servicecatalog.api.model.ServiceInstance... items);
  public Boolean hasItems();
  public ServiceInstanceListFluent.ItemsNested<A> addNewItem();
  public ServiceInstanceListFluent.ItemsNested<A> addNewItemLike(ServiceInstance item);
  public ServiceInstanceListFluent.ItemsNested<A> setNewItemLike(Integer index,ServiceInstance item);
  public ServiceInstanceListFluent.ItemsNested<A> editItem(Integer index);
  public ServiceInstanceListFluent.ItemsNested<A> editFirstItem();
  public ServiceInstanceListFluent.ItemsNested<A> editLastItem();
  public ServiceInstanceListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceInstanceBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public interface ItemsNested<N> extends Nested<N>,ServiceInstanceFluent<ServiceInstanceListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}