package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceClassBuilder extends ClusterServiceClassFluentImpl<ClusterServiceClassBuilder> implements VisitableBuilder<ClusterServiceClass,ClusterServiceClassBuilder>{
  public ClusterServiceClassBuilder() {
    this(false);
  }
  public ClusterServiceClassBuilder(Boolean validationEnabled) {
    this(new ClusterServiceClass(), validationEnabled);
  }
  public ClusterServiceClassBuilder(ClusterServiceClassFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceClassBuilder(ClusterServiceClassFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceClass(), validationEnabled);
  }
  public ClusterServiceClassBuilder(ClusterServiceClassFluent<?> fluent,ClusterServiceClass instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceClassBuilder(ClusterServiceClassFluent<?> fluent,ClusterServiceClass instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceClassBuilder(ClusterServiceClass instance) {
    this(instance,false);
  }
  public ClusterServiceClassBuilder(ClusterServiceClass instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceClassFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceClass build() {
    ClusterServiceClass buildable = new ClusterServiceClass(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}