package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LocalObjectReferenceBuilder extends LocalObjectReferenceFluentImpl<LocalObjectReferenceBuilder> implements VisitableBuilder<LocalObjectReference,LocalObjectReferenceBuilder>{
  public LocalObjectReferenceBuilder() {
    this(false);
  }
  public LocalObjectReferenceBuilder(Boolean validationEnabled) {
    this(new LocalObjectReference(), validationEnabled);
  }
  public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LocalObjectReference(), validationEnabled);
  }
  public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent,LocalObjectReference instance) {
    this(fluent, instance, false);
  }
  public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent,LocalObjectReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  public LocalObjectReferenceBuilder(LocalObjectReference instance) {
    this(instance,false);
  }
  public LocalObjectReferenceBuilder(LocalObjectReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  LocalObjectReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public LocalObjectReference build() {
    LocalObjectReference buildable = new LocalObjectReference(fluent.getName());
    return buildable;
  }
  
}