package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBindingPropertiesStateBuilder extends ServiceBindingPropertiesStateFluentImpl<ServiceBindingPropertiesStateBuilder> implements VisitableBuilder<ServiceBindingPropertiesState,ServiceBindingPropertiesStateBuilder>{
  public ServiceBindingPropertiesStateBuilder() {
    this(false);
  }
  public ServiceBindingPropertiesStateBuilder(Boolean validationEnabled) {
    this(new ServiceBindingPropertiesState(), validationEnabled);
  }
  public ServiceBindingPropertiesStateBuilder(ServiceBindingPropertiesStateFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBindingPropertiesStateBuilder(ServiceBindingPropertiesStateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBindingPropertiesState(), validationEnabled);
  }
  public ServiceBindingPropertiesStateBuilder(ServiceBindingPropertiesStateFluent<?> fluent,ServiceBindingPropertiesState instance) {
    this(fluent, instance, false);
  }
  public ServiceBindingPropertiesStateBuilder(ServiceBindingPropertiesStateFluent<?> fluent,ServiceBindingPropertiesState instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withParameterChecksum(instance.getParameterChecksum()); 
    fluent.withParameters(instance.getParameters()); 
    fluent.withUserInfo(instance.getUserInfo()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBindingPropertiesStateBuilder(ServiceBindingPropertiesState instance) {
    this(instance,false);
  }
  public ServiceBindingPropertiesStateBuilder(ServiceBindingPropertiesState instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withParameterChecksum(instance.getParameterChecksum()); 
    this.withParameters(instance.getParameters()); 
    this.withUserInfo(instance.getUserInfo()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceBindingPropertiesStateFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBindingPropertiesState build() {
    ServiceBindingPropertiesState buildable = new ServiceBindingPropertiesState(fluent.getParameterChecksum(),fluent.getParameters(),fluent.getUserInfo());
    return buildable;
  }
  
}