package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceClassFluentImpl<A extends ServiceClassFluent<A>> extends BaseFluent<A> implements ServiceClassFluent<A>{
  public ServiceClassFluentImpl() {
  }
  public ServiceClassFluentImpl(ServiceClass instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ServiceClassSpecBuilder spec;
  private ServiceClassStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ServiceClassFluent.MetadataNested<A> withNewMetadata() {
    return new ServiceClassFluentImpl.MetadataNestedImpl();
  }
  public ServiceClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ServiceClassFluentImpl.MetadataNestedImpl(item);
  }
  public ServiceClassFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ServiceClassFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ServiceClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceClassSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ServiceClassSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ServiceClassSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ServiceClassSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ServiceClassFluent.SpecNested<A> withNewSpec() {
    return new ServiceClassFluentImpl.SpecNestedImpl();
  }
  public ServiceClassFluent.SpecNested<A> withNewSpecLike(ServiceClassSpec item) {
    return new ServiceClassFluentImpl.SpecNestedImpl(item);
  }
  public ServiceClassFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ServiceClassFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ServiceClassSpecBuilder().build());
  }
  public ServiceClassFluent.SpecNested<A> editOrNewSpecLike(ServiceClassSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceClassStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ServiceClassStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ServiceClassStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ServiceClassStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public A withNewStatus(Boolean removedFromBrokerCatalog) {
    return (A)withStatus(new ServiceClassStatus(removedFromBrokerCatalog));
  }
  public ServiceClassFluent.StatusNested<A> withNewStatus() {
    return new ServiceClassFluentImpl.StatusNestedImpl();
  }
  public ServiceClassFluent.StatusNested<A> withNewStatusLike(ServiceClassStatus item) {
    return new ServiceClassFluentImpl.StatusNestedImpl(item);
  }
  public ServiceClassFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ServiceClassFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ServiceClassStatusBuilder().build());
  }
  public ServiceClassFluent.StatusNested<A> editOrNewStatusLike(ServiceClassStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceClassFluentImpl that = (ServiceClassFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ServiceClassFluent.MetadataNested<N>> implements ServiceClassFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ServiceClassFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ServiceClassSpecFluentImpl<ServiceClassFluent.SpecNested<N>> implements ServiceClassFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ServiceClassSpec item) {
      this.builder = new ServiceClassSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ServiceClassSpecBuilder(this);
    }
    ServiceClassSpecBuilder builder;
    public N and() {
      return (N) ServiceClassFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ServiceClassStatusFluentImpl<ServiceClassFluent.StatusNested<N>> implements ServiceClassFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ServiceClassStatus item) {
      this.builder = new ServiceClassStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ServiceClassStatusBuilder(this);
    }
    ServiceClassStatusBuilder builder;
    public N and() {
      return (N) ServiceClassFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}