package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceBrokerAuthInfoBuilder extends ClusterServiceBrokerAuthInfoFluentImpl<ClusterServiceBrokerAuthInfoBuilder> implements VisitableBuilder<ClusterServiceBrokerAuthInfo,ClusterServiceBrokerAuthInfoBuilder>{
  public ClusterServiceBrokerAuthInfoBuilder() {
    this(false);
  }
  public ClusterServiceBrokerAuthInfoBuilder(Boolean validationEnabled) {
    this(new ClusterServiceBrokerAuthInfo(), validationEnabled);
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceBrokerAuthInfo(), validationEnabled);
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfoFluent<?> fluent,ClusterServiceBrokerAuthInfo instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfoFluent<?> fluent,ClusterServiceBrokerAuthInfo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBasic(instance.getBasic()); 
    fluent.withBearer(instance.getBearer()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfo instance) {
    this(instance,false);
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfo instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBasic(instance.getBasic()); 
    this.withBearer(instance.getBearer()); 
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceBrokerAuthInfoFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceBrokerAuthInfo build() {
    ClusterServiceBrokerAuthInfo buildable = new ClusterServiceBrokerAuthInfo(fluent.getBasic(),fluent.getBearer());
    return buildable;
  }
  
}