package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBindingSpecBuilder extends ServiceBindingSpecFluentImpl<ServiceBindingSpecBuilder> implements VisitableBuilder<ServiceBindingSpec,ServiceBindingSpecBuilder>{
  public ServiceBindingSpecBuilder() {
    this(false);
  }
  public ServiceBindingSpecBuilder(Boolean validationEnabled) {
    this(new ServiceBindingSpec(), validationEnabled);
  }
  public ServiceBindingSpecBuilder(ServiceBindingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBindingSpecBuilder(ServiceBindingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBindingSpec(), validationEnabled);
  }
  public ServiceBindingSpecBuilder(ServiceBindingSpecFluent<?> fluent,ServiceBindingSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceBindingSpecBuilder(ServiceBindingSpecFluent<?> fluent,ServiceBindingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExternalID(instance.getExternalID()); 
    fluent.withInstanceRef(instance.getInstanceRef()); 
    fluent.withParameters(instance.getParameters()); 
    fluent.withParametersFrom(instance.getParametersFrom()); 
    fluent.withSecretName(instance.getSecretName()); 
    fluent.withSecretTransforms(instance.getSecretTransforms()); 
    fluent.withUserInfo(instance.getUserInfo()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBindingSpecBuilder(ServiceBindingSpec instance) {
    this(instance,false);
  }
  public ServiceBindingSpecBuilder(ServiceBindingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExternalID(instance.getExternalID()); 
    this.withInstanceRef(instance.getInstanceRef()); 
    this.withParameters(instance.getParameters()); 
    this.withParametersFrom(instance.getParametersFrom()); 
    this.withSecretName(instance.getSecretName()); 
    this.withSecretTransforms(instance.getSecretTransforms()); 
    this.withUserInfo(instance.getUserInfo()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceBindingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBindingSpec build() {
    ServiceBindingSpec buildable = new ServiceBindingSpec(fluent.getExternalID(),fluent.getInstanceRef(),fluent.getParameters(),fluent.getParametersFrom(),fluent.getSecretName(),fluent.getSecretTransforms(),fluent.getUserInfo());
    return buildable;
  }
  
}