package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface ServiceBrokerFluent<A extends ServiceBrokerFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ServiceBrokerFluent.MetadataNested<A> withNewMetadata();
  public ServiceBrokerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ServiceBrokerFluent.MetadataNested<A> editMetadata();
  public ServiceBrokerFluent.MetadataNested<A> editOrNewMetadata();
  public ServiceBrokerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceBrokerSpec getSpec();
  public ServiceBrokerSpec buildSpec();
  public A withSpec(ServiceBrokerSpec spec);
  public Boolean hasSpec();
  public ServiceBrokerFluent.SpecNested<A> withNewSpec();
  public ServiceBrokerFluent.SpecNested<A> withNewSpecLike(ServiceBrokerSpec item);
  public ServiceBrokerFluent.SpecNested<A> editSpec();
  public ServiceBrokerFluent.SpecNested<A> editOrNewSpec();
  public ServiceBrokerFluent.SpecNested<A> editOrNewSpecLike(ServiceBrokerSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceBrokerStatus getStatus();
  public ServiceBrokerStatus buildStatus();
  public A withStatus(ServiceBrokerStatus status);
  public Boolean hasStatus();
  public ServiceBrokerFluent.StatusNested<A> withNewStatus();
  public ServiceBrokerFluent.StatusNested<A> withNewStatusLike(ServiceBrokerStatus item);
  public ServiceBrokerFluent.StatusNested<A> editStatus();
  public ServiceBrokerFluent.StatusNested<A> editOrNewStatus();
  public ServiceBrokerFluent.StatusNested<A> editOrNewStatusLike(ServiceBrokerStatus item);
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ServiceBrokerFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ServiceBrokerSpecFluent<ServiceBrokerFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ServiceBrokerStatusFluent<ServiceBrokerFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}