package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterBasicAuthConfigBuilder extends ClusterBasicAuthConfigFluentImpl<ClusterBasicAuthConfigBuilder> implements VisitableBuilder<ClusterBasicAuthConfig,ClusterBasicAuthConfigBuilder>{
  public ClusterBasicAuthConfigBuilder() {
    this(false);
  }
  public ClusterBasicAuthConfigBuilder(Boolean validationEnabled) {
    this(new ClusterBasicAuthConfig(), validationEnabled);
  }
  public ClusterBasicAuthConfigBuilder(ClusterBasicAuthConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterBasicAuthConfigBuilder(ClusterBasicAuthConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterBasicAuthConfig(), validationEnabled);
  }
  public ClusterBasicAuthConfigBuilder(ClusterBasicAuthConfigFluent<?> fluent,ClusterBasicAuthConfig instance) {
    this(fluent, instance, false);
  }
  public ClusterBasicAuthConfigBuilder(ClusterBasicAuthConfigFluent<?> fluent,ClusterBasicAuthConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterBasicAuthConfigBuilder(ClusterBasicAuthConfig instance) {
    this(instance,false);
  }
  public ClusterBasicAuthConfigBuilder(ClusterBasicAuthConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterBasicAuthConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterBasicAuthConfig build() {
    ClusterBasicAuthConfig buildable = new ClusterBasicAuthConfig(fluent.getSecretRef());
    return buildable;
  }
  
}