package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceBrokerBuilder extends ClusterServiceBrokerFluentImpl<ClusterServiceBrokerBuilder> implements VisitableBuilder<ClusterServiceBroker,ClusterServiceBrokerBuilder>{
  public ClusterServiceBrokerBuilder() {
    this(false);
  }
  public ClusterServiceBrokerBuilder(Boolean validationEnabled) {
    this(new ClusterServiceBroker(), validationEnabled);
  }
  public ClusterServiceBrokerBuilder(ClusterServiceBrokerFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceBrokerBuilder(ClusterServiceBrokerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceBroker(), validationEnabled);
  }
  public ClusterServiceBrokerBuilder(ClusterServiceBrokerFluent<?> fluent,ClusterServiceBroker instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceBrokerBuilder(ClusterServiceBrokerFluent<?> fluent,ClusterServiceBroker instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceBrokerBuilder(ClusterServiceBroker instance) {
    this(instance,false);
  }
  public ClusterServiceBrokerBuilder(ClusterServiceBroker instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceBrokerFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceBroker build() {
    ClusterServiceBroker buildable = new ClusterServiceBroker(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}