package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterServiceBrokerStatusFluentImpl<A extends ClusterServiceBrokerStatusFluent<A>> extends BaseFluent<A> implements ClusterServiceBrokerStatusFluent<A>{
  public ClusterServiceBrokerStatusFluentImpl() {
  }
  public ClusterServiceBrokerStatusFluentImpl(ClusterServiceBrokerStatus instance) {
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withLastCatalogRetrievalTime(instance.getLastCatalogRetrievalTime());
      this.withOperationStartTime(instance.getOperationStartTime());
      this.withReconciledGeneration(instance.getReconciledGeneration());
    }
  }
  private ArrayList<ServiceBrokerConditionBuilder> conditions = new ArrayList<ServiceBrokerConditionBuilder>();
  private String lastCatalogRetrievalTime;
  private String operationStartTime;
  private Long reconciledGeneration;
  public A addToConditions(int index,ServiceBrokerCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBrokerConditionBuilder>();}
    ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,ServiceBrokerCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBrokerConditionBuilder>();}
    ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.servicecatalog.api.model.ServiceBrokerCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBrokerConditionBuilder>();}
    for (ServiceBrokerCondition item : items) {ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ServiceBrokerCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBrokerConditionBuilder>();}
    for (ServiceBrokerCondition item : items) {ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.servicecatalog.api.model.ServiceBrokerCondition... items) {
    for (ServiceBrokerCondition item : items) {ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ServiceBrokerCondition> items) {
    for (ServiceBrokerCondition item : items) {ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ServiceBrokerConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ServiceBrokerConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ServiceBrokerConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceBrokerCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ServiceBrokerCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ServiceBrokerCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public ServiceBrokerCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ServiceBrokerCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ServiceBrokerCondition buildMatchingCondition(Predicate<ServiceBrokerConditionBuilder> predicate) {
    for (ServiceBrokerConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ServiceBrokerConditionBuilder> predicate) {
    for (ServiceBrokerConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ServiceBrokerCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ServiceBrokerCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.servicecatalog.api.model.ServiceBrokerCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ServiceBrokerCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ServiceBrokerCondition(lastTransitionTime, message, reason, status, type));
  }
  public ClusterServiceBrokerStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new ClusterServiceBrokerStatusFluentImpl.ConditionsNestedImpl();
  }
  public ClusterServiceBrokerStatusFluentImpl.ConditionsNested<A> addNewConditionLike(ServiceBrokerCondition item) {
    return new ClusterServiceBrokerStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ClusterServiceBrokerStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,ServiceBrokerCondition item) {
    return new ClusterServiceBrokerStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ClusterServiceBrokerStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterServiceBrokerStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ClusterServiceBrokerStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterServiceBrokerStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<ServiceBrokerConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getLastCatalogRetrievalTime() {
    return this.lastCatalogRetrievalTime;
  }
  public A withLastCatalogRetrievalTime(String lastCatalogRetrievalTime) {
    this.lastCatalogRetrievalTime=lastCatalogRetrievalTime; return (A) this;
  }
  public Boolean hasLastCatalogRetrievalTime() {
    return this.lastCatalogRetrievalTime != null;
  }
  public String getOperationStartTime() {
    return this.operationStartTime;
  }
  public A withOperationStartTime(String operationStartTime) {
    this.operationStartTime=operationStartTime; return (A) this;
  }
  public Boolean hasOperationStartTime() {
    return this.operationStartTime != null;
  }
  public Long getReconciledGeneration() {
    return this.reconciledGeneration;
  }
  public A withReconciledGeneration(Long reconciledGeneration) {
    this.reconciledGeneration=reconciledGeneration; return (A) this;
  }
  public Boolean hasReconciledGeneration() {
    return this.reconciledGeneration != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterServiceBrokerStatusFluentImpl that = (ClusterServiceBrokerStatusFluentImpl) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(lastCatalogRetrievalTime, that.lastCatalogRetrievalTime)) return false;

    if (!java.util.Objects.equals(operationStartTime, that.operationStartTime)) return false;

    if (!java.util.Objects.equals(reconciledGeneration, that.reconciledGeneration)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  lastCatalogRetrievalTime,  operationStartTime,  reconciledGeneration,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (lastCatalogRetrievalTime != null) { sb.append("lastCatalogRetrievalTime:"); sb.append(lastCatalogRetrievalTime + ","); }
    if (operationStartTime != null) { sb.append("operationStartTime:"); sb.append(operationStartTime + ","); }
    if (reconciledGeneration != null) { sb.append("reconciledGeneration:"); sb.append(reconciledGeneration); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ServiceBrokerConditionFluentImpl<ClusterServiceBrokerStatusFluentImpl.ConditionsNested<N>> implements ClusterServiceBrokerStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,ServiceBrokerCondition item) {
      this.index = index;
      this.builder = new ServiceBrokerConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceBrokerConditionBuilder(this);
    }
    ServiceBrokerConditionBuilder builder;
    int index;
    public N and() {
      return (N) ClusterServiceBrokerStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}