package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface ClusterServiceClassFluent<A extends ClusterServiceClassFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ClusterServiceClassFluent.MetadataNested<A> withNewMetadata();
  public ClusterServiceClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ClusterServiceClassFluent.MetadataNested<A> editMetadata();
  public ClusterServiceClassFluent.MetadataNested<A> editOrNewMetadata();
  public ClusterServiceClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterServiceClassSpec getSpec();
  public ClusterServiceClassSpec buildSpec();
  public A withSpec(ClusterServiceClassSpec spec);
  public Boolean hasSpec();
  public ClusterServiceClassFluent.SpecNested<A> withNewSpec();
  public ClusterServiceClassFluent.SpecNested<A> withNewSpecLike(ClusterServiceClassSpec item);
  public ClusterServiceClassFluent.SpecNested<A> editSpec();
  public ClusterServiceClassFluent.SpecNested<A> editOrNewSpec();
  public ClusterServiceClassFluent.SpecNested<A> editOrNewSpecLike(ClusterServiceClassSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterServiceClassStatus getStatus();
  public ClusterServiceClassStatus buildStatus();
  public A withStatus(ClusterServiceClassStatus status);
  public Boolean hasStatus();
  public A withNewStatus(Boolean removedFromBrokerCatalog);
  public ClusterServiceClassFluent.StatusNested<A> withNewStatus();
  public ClusterServiceClassFluent.StatusNested<A> withNewStatusLike(ClusterServiceClassStatus item);
  public ClusterServiceClassFluent.StatusNested<A> editStatus();
  public ClusterServiceClassFluent.StatusNested<A> editOrNewStatus();
  public ClusterServiceClassFluent.StatusNested<A> editOrNewStatusLike(ClusterServiceClassStatus item);
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ClusterServiceClassFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ClusterServiceClassSpecFluent<ClusterServiceClassFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ClusterServiceClassStatusFluent<ClusterServiceClassFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}