package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServicePlanListBuilder extends ClusterServicePlanListFluentImpl<ClusterServicePlanListBuilder> implements VisitableBuilder<ClusterServicePlanList,ClusterServicePlanListBuilder>{
  public ClusterServicePlanListBuilder() {
    this(false);
  }
  public ClusterServicePlanListBuilder(Boolean validationEnabled) {
    this(new ClusterServicePlanList(), validationEnabled);
  }
  public ClusterServicePlanListBuilder(ClusterServicePlanListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServicePlanListBuilder(ClusterServicePlanListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServicePlanList(), validationEnabled);
  }
  public ClusterServicePlanListBuilder(ClusterServicePlanListFluent<?> fluent,ClusterServicePlanList instance) {
    this(fluent, instance, false);
  }
  public ClusterServicePlanListBuilder(ClusterServicePlanListFluent<?> fluent,ClusterServicePlanList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServicePlanListBuilder(ClusterServicePlanList instance) {
    this(instance,false);
  }
  public ClusterServicePlanListBuilder(ClusterServicePlanList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServicePlanListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServicePlanList build() {
    ClusterServicePlanList buildable = new ClusterServicePlanList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}