package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectReferenceBuilder extends ObjectReferenceFluentImpl<ObjectReferenceBuilder> implements VisitableBuilder<ObjectReference,ObjectReferenceBuilder>{
  public ObjectReferenceBuilder() {
    this(false);
  }
  public ObjectReferenceBuilder(Boolean validationEnabled) {
    this(new ObjectReference(), validationEnabled);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObjectReference(), validationEnabled);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent,ObjectReference instance) {
    this(fluent, instance, false);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent,ObjectReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ObjectReferenceBuilder(ObjectReference instance) {
    this(instance,false);
  }
  public ObjectReferenceBuilder(ObjectReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
    }
    this.validationEnabled = validationEnabled; 
  }
  ObjectReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ObjectReference build() {
    ObjectReference buildable = new ObjectReference(fluent.getName(),fluent.getNamespace());
    return buildable;
  }
  
}