package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBindingListBuilder extends ServiceBindingListFluentImpl<ServiceBindingListBuilder> implements VisitableBuilder<ServiceBindingList,ServiceBindingListBuilder>{
  public ServiceBindingListBuilder() {
    this(false);
  }
  public ServiceBindingListBuilder(Boolean validationEnabled) {
    this(new ServiceBindingList(), validationEnabled);
  }
  public ServiceBindingListBuilder(ServiceBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBindingListBuilder(ServiceBindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBindingList(), validationEnabled);
  }
  public ServiceBindingListBuilder(ServiceBindingListFluent<?> fluent,ServiceBindingList instance) {
    this(fluent, instance, false);
  }
  public ServiceBindingListBuilder(ServiceBindingListFluent<?> fluent,ServiceBindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBindingListBuilder(ServiceBindingList instance) {
    this(instance,false);
  }
  public ServiceBindingListBuilder(ServiceBindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceBindingListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBindingList build() {
    ServiceBindingList buildable = new ServiceBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}