package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface ServiceClassFluent<A extends ServiceClassFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ServiceClassFluent.MetadataNested<A> withNewMetadata();
  public ServiceClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ServiceClassFluent.MetadataNested<A> editMetadata();
  public ServiceClassFluent.MetadataNested<A> editOrNewMetadata();
  public ServiceClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceClassSpec getSpec();
  public ServiceClassSpec buildSpec();
  public A withSpec(ServiceClassSpec spec);
  public Boolean hasSpec();
  public ServiceClassFluent.SpecNested<A> withNewSpec();
  public ServiceClassFluent.SpecNested<A> withNewSpecLike(ServiceClassSpec item);
  public ServiceClassFluent.SpecNested<A> editSpec();
  public ServiceClassFluent.SpecNested<A> editOrNewSpec();
  public ServiceClassFluent.SpecNested<A> editOrNewSpecLike(ServiceClassSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceClassStatus getStatus();
  public ServiceClassStatus buildStatus();
  public A withStatus(ServiceClassStatus status);
  public Boolean hasStatus();
  public A withNewStatus(Boolean removedFromBrokerCatalog);
  public ServiceClassFluent.StatusNested<A> withNewStatus();
  public ServiceClassFluent.StatusNested<A> withNewStatusLike(ServiceClassStatus item);
  public ServiceClassFluent.StatusNested<A> editStatus();
  public ServiceClassFluent.StatusNested<A> editOrNewStatus();
  public ServiceClassFluent.StatusNested<A> editOrNewStatusLike(ServiceClassStatus item);
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ServiceClassFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ServiceClassSpecFluent<ServiceClassFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ServiceClassStatusFluent<ServiceClassFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}