package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface ServiceInstanceFluent<A extends ServiceInstanceFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ServiceInstanceFluent.MetadataNested<A> withNewMetadata();
  public ServiceInstanceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ServiceInstanceFluent.MetadataNested<A> editMetadata();
  public ServiceInstanceFluent.MetadataNested<A> editOrNewMetadata();
  public ServiceInstanceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceInstanceSpec getSpec();
  public ServiceInstanceSpec buildSpec();
  public A withSpec(ServiceInstanceSpec spec);
  public Boolean hasSpec();
  public ServiceInstanceFluent.SpecNested<A> withNewSpec();
  public ServiceInstanceFluent.SpecNested<A> withNewSpecLike(ServiceInstanceSpec item);
  public ServiceInstanceFluent.SpecNested<A> editSpec();
  public ServiceInstanceFluent.SpecNested<A> editOrNewSpec();
  public ServiceInstanceFluent.SpecNested<A> editOrNewSpecLike(ServiceInstanceSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceInstanceStatus getStatus();
  public ServiceInstanceStatus buildStatus();
  public A withStatus(ServiceInstanceStatus status);
  public Boolean hasStatus();
  public ServiceInstanceFluent.StatusNested<A> withNewStatus();
  public ServiceInstanceFluent.StatusNested<A> withNewStatusLike(ServiceInstanceStatus item);
  public ServiceInstanceFluent.StatusNested<A> editStatus();
  public ServiceInstanceFluent.StatusNested<A> editOrNewStatus();
  public ServiceInstanceFluent.StatusNested<A> editOrNewStatusLike(ServiceInstanceStatus item);
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ServiceInstanceFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ServiceInstanceSpecFluent<ServiceInstanceFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ServiceInstanceStatusFluent<ServiceInstanceFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}