package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceInstanceFluentImpl<A extends ServiceInstanceFluent<A>> extends BaseFluent<A> implements ServiceInstanceFluent<A>{
  public ServiceInstanceFluentImpl() {
  }
  public ServiceInstanceFluentImpl(ServiceInstance instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ServiceInstanceSpecBuilder spec;
  private ServiceInstanceStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ServiceInstanceFluentImpl.MetadataNested<A> withNewMetadata() {
    return new ServiceInstanceFluentImpl.MetadataNestedImpl();
  }
  public ServiceInstanceFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ServiceInstanceFluentImpl.MetadataNestedImpl(item);
  }
  public ServiceInstanceFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ServiceInstanceFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ServiceInstanceFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceInstanceSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ServiceInstanceSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ServiceInstanceSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ServiceInstanceSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ServiceInstanceFluentImpl.SpecNested<A> withNewSpec() {
    return new ServiceInstanceFluentImpl.SpecNestedImpl();
  }
  public ServiceInstanceFluentImpl.SpecNested<A> withNewSpecLike(ServiceInstanceSpec item) {
    return new ServiceInstanceFluentImpl.SpecNestedImpl(item);
  }
  public ServiceInstanceFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ServiceInstanceFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ServiceInstanceSpecBuilder().build());
  }
  public ServiceInstanceFluentImpl.SpecNested<A> editOrNewSpecLike(ServiceInstanceSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceInstanceStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ServiceInstanceStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ServiceInstanceStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ServiceInstanceStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ServiceInstanceFluentImpl.StatusNested<A> withNewStatus() {
    return new ServiceInstanceFluentImpl.StatusNestedImpl();
  }
  public ServiceInstanceFluentImpl.StatusNested<A> withNewStatusLike(ServiceInstanceStatus item) {
    return new ServiceInstanceFluentImpl.StatusNestedImpl(item);
  }
  public ServiceInstanceFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ServiceInstanceFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ServiceInstanceStatusBuilder().build());
  }
  public ServiceInstanceFluentImpl.StatusNested<A> editOrNewStatusLike(ServiceInstanceStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceInstanceFluentImpl that = (ServiceInstanceFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ServiceInstanceFluentImpl.MetadataNested<N>> implements ServiceInstanceFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ServiceInstanceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ServiceInstanceSpecFluentImpl<ServiceInstanceFluentImpl.SpecNested<N>> implements ServiceInstanceFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ServiceInstanceSpec item) {
      this.builder = new ServiceInstanceSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ServiceInstanceSpecBuilder(this);
    }
    ServiceInstanceSpecBuilder builder;
    public N and() {
      return (N) ServiceInstanceFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ServiceInstanceStatusFluentImpl<ServiceInstanceFluentImpl.StatusNested<N>> implements ServiceInstanceFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ServiceInstanceStatus item) {
      this.builder = new ServiceInstanceStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ServiceInstanceStatusBuilder(this);
    }
    ServiceInstanceStatusBuilder builder;
    public N and() {
      return (N) ServiceInstanceFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}