package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceInstanceListFluentImpl<A extends ServiceInstanceListFluent<A>> extends BaseFluent<A> implements ServiceInstanceListFluent<A>{
  public ServiceInstanceListFluentImpl() {
  }
  public ServiceInstanceListFluentImpl(ServiceInstanceList instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
  }
  private String apiVersion;
  private ArrayList<ServiceInstanceBuilder> items = new ArrayList<ServiceInstanceBuilder>();
  private String kind;
  private ListMeta metadata;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(int index,ServiceInstance item) {
    if (this.items == null) {this.items = new ArrayList<ServiceInstanceBuilder>();}
    ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToItems(int index,ServiceInstance item) {
    if (this.items == null) {this.items = new ArrayList<ServiceInstanceBuilder>();}
    ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToItems(io.fabric8.servicecatalog.api.model.ServiceInstance... items) {
    if (this.items == null) {this.items = new ArrayList<ServiceInstanceBuilder>();}
    for (ServiceInstance item : items) {ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<ServiceInstance> items) {
    if (this.items == null) {this.items = new ArrayList<ServiceInstanceBuilder>();}
    for (ServiceInstance item : items) {ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.servicecatalog.api.model.ServiceInstance... items) {
    for (ServiceInstance item : items) {ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(Collection<ServiceInstance> items) {
    for (ServiceInstance item : items) {ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<ServiceInstanceBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<ServiceInstanceBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      ServiceInstanceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceInstance> getItems() {
    return items != null ? build(items) : null;
  }
  public List<ServiceInstance> buildItems() {
    return items != null ? build(items) : null;
  }
  public ServiceInstance buildItem(int index) {
    return this.items.get(index).build();
  }
  public ServiceInstance buildFirstItem() {
    return this.items.get(0).build();
  }
  public ServiceInstance buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public ServiceInstance buildMatchingItem(Predicate<ServiceInstanceBuilder> predicate) {
    for (ServiceInstanceBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<ServiceInstanceBuilder> predicate) {
    for (ServiceInstanceBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<ServiceInstance> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (ServiceInstance item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.servicecatalog.api.model.ServiceInstance... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (ServiceInstance item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public ServiceInstanceListFluentImpl.ItemsNested<A> addNewItem() {
    return new ServiceInstanceListFluentImpl.ItemsNestedImpl();
  }
  public ServiceInstanceListFluentImpl.ItemsNested<A> addNewItemLike(ServiceInstance item) {
    return new ServiceInstanceListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public ServiceInstanceListFluentImpl.ItemsNested<A> setNewItemLike(int index,ServiceInstance item) {
    return new ServiceInstanceListFluentImpl.ItemsNestedImpl(index, item);
  }
  public ServiceInstanceListFluentImpl.ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public ServiceInstanceListFluentImpl.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public ServiceInstanceListFluentImpl.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public ServiceInstanceListFluentImpl.ItemsNested<A> editMatchingItem(Predicate<ServiceInstanceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public ListMeta getMetadata() {
    return this.metadata;
  }
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceInstanceListFluentImpl that = (ServiceInstanceListFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(items, that.items)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata); }
    sb.append("}");
    return sb.toString();
  }
  class ItemsNestedImpl<N> extends ServiceInstanceFluentImpl<ServiceInstanceListFluentImpl.ItemsNested<N>> implements ServiceInstanceListFluentImpl.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(int index,ServiceInstance item) {
      this.index = index;
      this.builder = new ServiceInstanceBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceInstanceBuilder(this);
    }
    ServiceInstanceBuilder builder;
    int index;
    public N and() {
      return (N) ServiceInstanceListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}