package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceInstancePropertiesStateFluentImpl<A extends ServiceInstancePropertiesStateFluent<A>> extends BaseFluent<A> implements ServiceInstancePropertiesStateFluent<A>{
  public ServiceInstancePropertiesStateFluentImpl() {
  }
  public ServiceInstancePropertiesStateFluentImpl(ServiceInstancePropertiesState instance) {
    if (instance != null) {
      this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
      this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
      this.withParameterChecksum(instance.getParameterChecksum());
      this.withParameters(instance.getParameters());
      this.withServicePlanExternalID(instance.getServicePlanExternalID());
      this.withServicePlanExternalName(instance.getServicePlanExternalName());
      this.withUserInfo(instance.getUserInfo());
    }
  }
  private String clusterServicePlanExternalID;
  private String clusterServicePlanExternalName;
  private String parameterChecksum;
  private Map<String,Object> parameters;
  private String servicePlanExternalID;
  private String servicePlanExternalName;
  private UserInfoBuilder userInfo;
  public String getClusterServicePlanExternalID() {
    return this.clusterServicePlanExternalID;
  }
  public A withClusterServicePlanExternalID(String clusterServicePlanExternalID) {
    this.clusterServicePlanExternalID=clusterServicePlanExternalID; return (A) this;
  }
  public Boolean hasClusterServicePlanExternalID() {
    return this.clusterServicePlanExternalID != null;
  }
  public String getClusterServicePlanExternalName() {
    return this.clusterServicePlanExternalName;
  }
  public A withClusterServicePlanExternalName(String clusterServicePlanExternalName) {
    this.clusterServicePlanExternalName=clusterServicePlanExternalName; return (A) this;
  }
  public Boolean hasClusterServicePlanExternalName() {
    return this.clusterServicePlanExternalName != null;
  }
  public String getParameterChecksum() {
    return this.parameterChecksum;
  }
  public A withParameterChecksum(String parameterChecksum) {
    this.parameterChecksum=parameterChecksum; return (A) this;
  }
  public Boolean hasParameterChecksum() {
    return this.parameterChecksum != null;
  }
  public A addToParameters(String key,Object value) {
    if(this.parameters == null && key != null && value != null) { this.parameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.parameters.put(key, value);} return (A)this;
  }
  public A addToParameters(Map<String,Object> map) {
    if(this.parameters == null && map != null) { this.parameters = new LinkedHashMap(); }
    if(map != null) { this.parameters.putAll(map);} return (A)this;
  }
  public A removeFromParameters(String key) {
    if(this.parameters == null) { return (A) this; }
    if(key != null && this.parameters != null) {this.parameters.remove(key);} return (A)this;
  }
  public A removeFromParameters(Map<String,Object> map) {
    if(this.parameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.parameters != null){this.parameters.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getParameters() {
    return this.parameters;
  }
  public <K,V>A withParameters(Map<String,Object> parameters) {
    if (parameters == null) { this.parameters =  null;} else {this.parameters = new LinkedHashMap(parameters);} return (A) this;
  }
  public Boolean hasParameters() {
    return this.parameters != null;
  }
  public String getServicePlanExternalID() {
    return this.servicePlanExternalID;
  }
  public A withServicePlanExternalID(String servicePlanExternalID) {
    this.servicePlanExternalID=servicePlanExternalID; return (A) this;
  }
  public Boolean hasServicePlanExternalID() {
    return this.servicePlanExternalID != null;
  }
  public String getServicePlanExternalName() {
    return this.servicePlanExternalName;
  }
  public A withServicePlanExternalName(String servicePlanExternalName) {
    this.servicePlanExternalName=servicePlanExternalName; return (A) this;
  }
  public Boolean hasServicePlanExternalName() {
    return this.servicePlanExternalName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUserInfo instead.
   * @return The buildable object.
   */
  @Deprecated
  public UserInfo getUserInfo() {
    return this.userInfo!=null ?this.userInfo.build():null;
  }
  public UserInfo buildUserInfo() {
    return this.userInfo!=null ?this.userInfo.build():null;
  }
  public A withUserInfo(UserInfo userInfo) {
    _visitables.get("userInfo").remove(this.userInfo);
    if (userInfo!=null){ this.userInfo= new UserInfoBuilder(userInfo); _visitables.get("userInfo").add(this.userInfo);} else { this.userInfo = null; _visitables.get("userInfo").remove(this.userInfo); } return (A) this;
  }
  public Boolean hasUserInfo() {
    return this.userInfo != null;
  }
  public ServiceInstancePropertiesStateFluentImpl.UserInfoNested<A> withNewUserInfo() {
    return new ServiceInstancePropertiesStateFluentImpl.UserInfoNestedImpl();
  }
  public ServiceInstancePropertiesStateFluentImpl.UserInfoNested<A> withNewUserInfoLike(UserInfo item) {
    return new ServiceInstancePropertiesStateFluentImpl.UserInfoNestedImpl(item);
  }
  public ServiceInstancePropertiesStateFluentImpl.UserInfoNested<A> editUserInfo() {
    return withNewUserInfoLike(getUserInfo());
  }
  public ServiceInstancePropertiesStateFluentImpl.UserInfoNested<A> editOrNewUserInfo() {
    return withNewUserInfoLike(getUserInfo() != null ? getUserInfo(): new UserInfoBuilder().build());
  }
  public ServiceInstancePropertiesStateFluentImpl.UserInfoNested<A> editOrNewUserInfoLike(UserInfo item) {
    return withNewUserInfoLike(getUserInfo() != null ? getUserInfo(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceInstancePropertiesStateFluentImpl that = (ServiceInstancePropertiesStateFluentImpl) o;
    if (!java.util.Objects.equals(clusterServicePlanExternalID, that.clusterServicePlanExternalID)) return false;

    if (!java.util.Objects.equals(clusterServicePlanExternalName, that.clusterServicePlanExternalName)) return false;

    if (!java.util.Objects.equals(parameterChecksum, that.parameterChecksum)) return false;

    if (!java.util.Objects.equals(parameters, that.parameters)) return false;

    if (!java.util.Objects.equals(servicePlanExternalID, that.servicePlanExternalID)) return false;

    if (!java.util.Objects.equals(servicePlanExternalName, that.servicePlanExternalName)) return false;

    if (!java.util.Objects.equals(userInfo, that.userInfo)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterServicePlanExternalID,  clusterServicePlanExternalName,  parameterChecksum,  parameters,  servicePlanExternalID,  servicePlanExternalName,  userInfo,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterServicePlanExternalID != null) { sb.append("clusterServicePlanExternalID:"); sb.append(clusterServicePlanExternalID + ","); }
    if (clusterServicePlanExternalName != null) { sb.append("clusterServicePlanExternalName:"); sb.append(clusterServicePlanExternalName + ","); }
    if (parameterChecksum != null) { sb.append("parameterChecksum:"); sb.append(parameterChecksum + ","); }
    if (parameters != null && !parameters.isEmpty()) { sb.append("parameters:"); sb.append(parameters + ","); }
    if (servicePlanExternalID != null) { sb.append("servicePlanExternalID:"); sb.append(servicePlanExternalID + ","); }
    if (servicePlanExternalName != null) { sb.append("servicePlanExternalName:"); sb.append(servicePlanExternalName + ","); }
    if (userInfo != null) { sb.append("userInfo:"); sb.append(userInfo); }
    sb.append("}");
    return sb.toString();
  }
  class UserInfoNestedImpl<N> extends UserInfoFluentImpl<ServiceInstancePropertiesStateFluentImpl.UserInfoNested<N>> implements ServiceInstancePropertiesStateFluentImpl.UserInfoNested<N>,Nested<N>{
    UserInfoNestedImpl(UserInfo item) {
      this.builder = new UserInfoBuilder(this, item);
    }
    UserInfoNestedImpl() {
      this.builder = new UserInfoBuilder(this);
    }
    UserInfoBuilder builder;
    public N and() {
      return (N) ServiceInstancePropertiesStateFluentImpl.this.withUserInfo(builder.build());
    }
    public N endUserInfo() {
      return and();
    }
    
  }
  
}