/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.servicecatalog.api.model.LocalObjectReference;
import io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder;
import io.fabric8.servicecatalog.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.servicecatalog.api.model.ParametersFromSource;
import io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder;
import io.fabric8.servicecatalog.api.model.ParametersFromSourceFluentImpl;
import io.fabric8.servicecatalog.api.model.SecretTransform;
import io.fabric8.servicecatalog.api.model.SecretTransformBuilder;
import io.fabric8.servicecatalog.api.model.SecretTransformFluentImpl;
import io.fabric8.servicecatalog.api.model.ServiceBindingSpec;
import io.fabric8.servicecatalog.api.model.ServiceBindingSpecFluent;
import io.fabric8.servicecatalog.api.model.UserInfo;
import io.fabric8.servicecatalog.api.model.UserInfoBuilder;
import io.fabric8.servicecatalog.api.model.UserInfoFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceBindingSpecFluentImpl<A extends ServiceBindingSpecFluent<A>>
extends BaseFluent<A>
implements ServiceBindingSpecFluent<A> {
    private String externalID;
    private LocalObjectReferenceBuilder instanceRef;
    private Map<String, Object> parameters;
    private ArrayList<ParametersFromSourceBuilder> parametersFrom = new ArrayList();
    private String secretName;
    private ArrayList<SecretTransformBuilder> secretTransforms = new ArrayList();
    private UserInfoBuilder userInfo;

    public ServiceBindingSpecFluentImpl() {
    }

    public ServiceBindingSpecFluentImpl(ServiceBindingSpec instance) {
        if (instance != null) {
            this.withExternalID(instance.getExternalID());
            this.withInstanceRef(instance.getInstanceRef());
            this.withParameters(instance.getParameters());
            this.withParametersFrom(instance.getParametersFrom());
            this.withSecretName(instance.getSecretName());
            this.withSecretTransforms(instance.getSecretTransforms());
            this.withUserInfo(instance.getUserInfo());
        }
    }

    @Override
    public String getExternalID() {
        return this.externalID;
    }

    @Override
    public A withExternalID(String externalID) {
        this.externalID = externalID;
        return (A)this;
    }

    @Override
    public Boolean hasExternalID() {
        return this.externalID != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getInstanceRef() {
        return this.instanceRef != null ? this.instanceRef.build() : null;
    }

    @Override
    public LocalObjectReference buildInstanceRef() {
        return this.instanceRef != null ? this.instanceRef.build() : null;
    }

    @Override
    public A withInstanceRef(LocalObjectReference instanceRef) {
        this._visitables.get((Object)"instanceRef").remove(this.instanceRef);
        if (instanceRef != null) {
            this.instanceRef = new LocalObjectReferenceBuilder(instanceRef);
            this._visitables.get((Object)"instanceRef").add(this.instanceRef);
        } else {
            this.instanceRef = null;
            this._visitables.get((Object)"instanceRef").remove(this.instanceRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInstanceRef() {
        return this.instanceRef != null;
    }

    @Override
    public A withNewInstanceRef(String name) {
        return this.withInstanceRef(new LocalObjectReference(name));
    }

    @Override
    public ServiceBindingSpecFluent.InstanceRefNested<A> withNewInstanceRef() {
        return new InstanceRefNestedImpl();
    }

    @Override
    public ServiceBindingSpecFluent.InstanceRefNested<A> withNewInstanceRefLike(LocalObjectReference item) {
        return new InstanceRefNestedImpl(item);
    }

    @Override
    public ServiceBindingSpecFluent.InstanceRefNested<A> editInstanceRef() {
        return this.withNewInstanceRefLike(this.getInstanceRef());
    }

    @Override
    public ServiceBindingSpecFluent.InstanceRefNested<A> editOrNewInstanceRef() {
        return this.withNewInstanceRefLike(this.getInstanceRef() != null ? this.getInstanceRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ServiceBindingSpecFluent.InstanceRefNested<A> editOrNewInstanceRefLike(LocalObjectReference item) {
        return this.withNewInstanceRefLike(this.getInstanceRef() != null ? this.getInstanceRef() : item);
    }

    @Override
    public A addToParameters(String key, Object value) {
        if (this.parameters == null && key != null && value != null) {
            this.parameters = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToParameters(Map<String, Object> map) {
        if (this.parameters == null && map != null) {
            this.parameters = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.parameters.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromParameters(String key) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (key != null && this.parameters != null) {
            this.parameters.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromParameters(Map<String, Object> map) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.parameters == null) continue;
                this.parameters.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public <K, V> A withParameters(Map<String, Object> parameters) {
        this.parameters = parameters == null ? null : new LinkedHashMap<String, Object>(parameters);
        return (A)this;
    }

    @Override
    public Boolean hasParameters() {
        return this.parameters != null;
    }

    @Override
    public A addToParametersFrom(int index, ParametersFromSource item) {
        if (this.parametersFrom == null) {
            this.parametersFrom = new ArrayList();
        }
        ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
        if (index < 0 || index >= this.parametersFrom.size()) {
            this._visitables.get((Object)"parametersFrom").add(builder);
            this.parametersFrom.add(builder);
        } else {
            this._visitables.get((Object)"parametersFrom").add(index, builder);
            this.parametersFrom.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToParametersFrom(int index, ParametersFromSource item) {
        if (this.parametersFrom == null) {
            this.parametersFrom = new ArrayList();
        }
        ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
        if (index < 0 || index >= this.parametersFrom.size()) {
            this._visitables.get((Object)"parametersFrom").add(builder);
            this.parametersFrom.add(builder);
        } else {
            this._visitables.get((Object)"parametersFrom").set(index, builder);
            this.parametersFrom.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToParametersFrom(ParametersFromSource ... items) {
        if (this.parametersFrom == null) {
            this.parametersFrom = new ArrayList();
        }
        for (ParametersFromSource item : items) {
            ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
            this._visitables.get((Object)"parametersFrom").add(builder);
            this.parametersFrom.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToParametersFrom(Collection<ParametersFromSource> items) {
        if (this.parametersFrom == null) {
            this.parametersFrom = new ArrayList();
        }
        for (ParametersFromSource item : items) {
            ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
            this._visitables.get((Object)"parametersFrom").add(builder);
            this.parametersFrom.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromParametersFrom(ParametersFromSource ... items) {
        for (ParametersFromSource item : items) {
            ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
            this._visitables.get((Object)"parametersFrom").remove(builder);
            if (this.parametersFrom == null) continue;
            this.parametersFrom.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromParametersFrom(Collection<ParametersFromSource> items) {
        for (ParametersFromSource item : items) {
            ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
            this._visitables.get((Object)"parametersFrom").remove(builder);
            if (this.parametersFrom == null) continue;
            this.parametersFrom.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
        if (this.parametersFrom == null) {
            return (A)this;
        }
        Iterator<ParametersFromSourceBuilder> each = this.parametersFrom.iterator();
        List visitables = this._visitables.get((Object)"parametersFrom");
        while (each.hasNext()) {
            ParametersFromSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ParametersFromSource> getParametersFrom() {
        return this.parametersFrom != null ? ServiceBindingSpecFluentImpl.build(this.parametersFrom) : null;
    }

    @Override
    public List<ParametersFromSource> buildParametersFrom() {
        return this.parametersFrom != null ? ServiceBindingSpecFluentImpl.build(this.parametersFrom) : null;
    }

    @Override
    public ParametersFromSource buildParametersFrom(int index) {
        return this.parametersFrom.get(index).build();
    }

    @Override
    public ParametersFromSource buildFirstParametersFrom() {
        return this.parametersFrom.get(0).build();
    }

    @Override
    public ParametersFromSource buildLastParametersFrom() {
        return this.parametersFrom.get(this.parametersFrom.size() - 1).build();
    }

    @Override
    public ParametersFromSource buildMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
        for (ParametersFromSourceBuilder item : this.parametersFrom) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
        for (ParametersFromSourceBuilder item : this.parametersFrom) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withParametersFrom(List<ParametersFromSource> parametersFrom) {
        if (this.parametersFrom != null) {
            this._visitables.get((Object)"parametersFrom").clear();
        }
        if (parametersFrom != null) {
            this.parametersFrom = new ArrayList();
            for (ParametersFromSource item : parametersFrom) {
                this.addToParametersFrom(item);
            }
        } else {
            this.parametersFrom = null;
        }
        return (A)this;
    }

    @Override
    public A withParametersFrom(ParametersFromSource ... parametersFrom) {
        if (this.parametersFrom != null) {
            this.parametersFrom.clear();
            this._visitables.remove((Object)"parametersFrom");
        }
        if (parametersFrom != null) {
            for (ParametersFromSource item : parametersFrom) {
                this.addToParametersFrom(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasParametersFrom() {
        return this.parametersFrom != null && !this.parametersFrom.isEmpty();
    }

    @Override
    public ServiceBindingSpecFluent.ParametersFromNested<A> addNewParametersFrom() {
        return new ParametersFromNestedImpl();
    }

    @Override
    public ServiceBindingSpecFluent.ParametersFromNested<A> addNewParametersFromLike(ParametersFromSource item) {
        return new ParametersFromNestedImpl(-1, item);
    }

    @Override
    public ServiceBindingSpecFluent.ParametersFromNested<A> setNewParametersFromLike(int index, ParametersFromSource item) {
        return new ParametersFromNestedImpl(index, item);
    }

    @Override
    public ServiceBindingSpecFluent.ParametersFromNested<A> editParametersFrom(int index) {
        if (this.parametersFrom.size() <= index) {
            throw new RuntimeException("Can't edit parametersFrom. Index exceeds size.");
        }
        return this.setNewParametersFromLike(index, this.buildParametersFrom(index));
    }

    @Override
    public ServiceBindingSpecFluent.ParametersFromNested<A> editFirstParametersFrom() {
        if (this.parametersFrom.size() == 0) {
            throw new RuntimeException("Can't edit first parametersFrom. The list is empty.");
        }
        return this.setNewParametersFromLike(0, this.buildParametersFrom(0));
    }

    @Override
    public ServiceBindingSpecFluent.ParametersFromNested<A> editLastParametersFrom() {
        int index = this.parametersFrom.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parametersFrom. The list is empty.");
        }
        return this.setNewParametersFromLike(index, this.buildParametersFrom(index));
    }

    @Override
    public ServiceBindingSpecFluent.ParametersFromNested<A> editMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parametersFrom.size(); ++i) {
            if (!predicate.test(this.parametersFrom.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parametersFrom. No match found.");
        }
        return this.setNewParametersFromLike(index, this.buildParametersFrom(index));
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    @Override
    public A addToSecretTransforms(int index, SecretTransform item) {
        if (this.secretTransforms == null) {
            this.secretTransforms = new ArrayList();
        }
        SecretTransformBuilder builder = new SecretTransformBuilder(item);
        if (index < 0 || index >= this.secretTransforms.size()) {
            this._visitables.get((Object)"secretTransforms").add(builder);
            this.secretTransforms.add(builder);
        } else {
            this._visitables.get((Object)"secretTransforms").add(index, builder);
            this.secretTransforms.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToSecretTransforms(int index, SecretTransform item) {
        if (this.secretTransforms == null) {
            this.secretTransforms = new ArrayList();
        }
        SecretTransformBuilder builder = new SecretTransformBuilder(item);
        if (index < 0 || index >= this.secretTransforms.size()) {
            this._visitables.get((Object)"secretTransforms").add(builder);
            this.secretTransforms.add(builder);
        } else {
            this._visitables.get((Object)"secretTransforms").set(index, builder);
            this.secretTransforms.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecretTransforms(SecretTransform ... items) {
        if (this.secretTransforms == null) {
            this.secretTransforms = new ArrayList();
        }
        for (SecretTransform item : items) {
            SecretTransformBuilder builder = new SecretTransformBuilder(item);
            this._visitables.get((Object)"secretTransforms").add(builder);
            this.secretTransforms.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecretTransforms(Collection<SecretTransform> items) {
        if (this.secretTransforms == null) {
            this.secretTransforms = new ArrayList();
        }
        for (SecretTransform item : items) {
            SecretTransformBuilder builder = new SecretTransformBuilder(item);
            this._visitables.get((Object)"secretTransforms").add(builder);
            this.secretTransforms.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecretTransforms(SecretTransform ... items) {
        for (SecretTransform item : items) {
            SecretTransformBuilder builder = new SecretTransformBuilder(item);
            this._visitables.get((Object)"secretTransforms").remove(builder);
            if (this.secretTransforms == null) continue;
            this.secretTransforms.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecretTransforms(Collection<SecretTransform> items) {
        for (SecretTransform item : items) {
            SecretTransformBuilder builder = new SecretTransformBuilder(item);
            this._visitables.get((Object)"secretTransforms").remove(builder);
            if (this.secretTransforms == null) continue;
            this.secretTransforms.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSecretTransforms(Predicate<SecretTransformBuilder> predicate) {
        if (this.secretTransforms == null) {
            return (A)this;
        }
        Iterator<SecretTransformBuilder> each = this.secretTransforms.iterator();
        List visitables = this._visitables.get((Object)"secretTransforms");
        while (each.hasNext()) {
            SecretTransformBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SecretTransform> getSecretTransforms() {
        return this.secretTransforms != null ? ServiceBindingSpecFluentImpl.build(this.secretTransforms) : null;
    }

    @Override
    public List<SecretTransform> buildSecretTransforms() {
        return this.secretTransforms != null ? ServiceBindingSpecFluentImpl.build(this.secretTransforms) : null;
    }

    @Override
    public SecretTransform buildSecretTransform(int index) {
        return this.secretTransforms.get(index).build();
    }

    @Override
    public SecretTransform buildFirstSecretTransform() {
        return this.secretTransforms.get(0).build();
    }

    @Override
    public SecretTransform buildLastSecretTransform() {
        return this.secretTransforms.get(this.secretTransforms.size() - 1).build();
    }

    @Override
    public SecretTransform buildMatchingSecretTransform(Predicate<SecretTransformBuilder> predicate) {
        for (SecretTransformBuilder item : this.secretTransforms) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecretTransform(Predicate<SecretTransformBuilder> predicate) {
        for (SecretTransformBuilder item : this.secretTransforms) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSecretTransforms(List<SecretTransform> secretTransforms) {
        if (this.secretTransforms != null) {
            this._visitables.get((Object)"secretTransforms").clear();
        }
        if (secretTransforms != null) {
            this.secretTransforms = new ArrayList();
            for (SecretTransform item : secretTransforms) {
                this.addToSecretTransforms(item);
            }
        } else {
            this.secretTransforms = null;
        }
        return (A)this;
    }

    @Override
    public A withSecretTransforms(SecretTransform ... secretTransforms) {
        if (this.secretTransforms != null) {
            this.secretTransforms.clear();
            this._visitables.remove((Object)"secretTransforms");
        }
        if (secretTransforms != null) {
            for (SecretTransform item : secretTransforms) {
                this.addToSecretTransforms(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretTransforms() {
        return this.secretTransforms != null && !this.secretTransforms.isEmpty();
    }

    @Override
    public ServiceBindingSpecFluent.SecretTransformsNested<A> addNewSecretTransform() {
        return new SecretTransformsNestedImpl();
    }

    @Override
    public ServiceBindingSpecFluent.SecretTransformsNested<A> addNewSecretTransformLike(SecretTransform item) {
        return new SecretTransformsNestedImpl(-1, item);
    }

    @Override
    public ServiceBindingSpecFluent.SecretTransformsNested<A> setNewSecretTransformLike(int index, SecretTransform item) {
        return new SecretTransformsNestedImpl(index, item);
    }

    @Override
    public ServiceBindingSpecFluent.SecretTransformsNested<A> editSecretTransform(int index) {
        if (this.secretTransforms.size() <= index) {
            throw new RuntimeException("Can't edit secretTransforms. Index exceeds size.");
        }
        return this.setNewSecretTransformLike(index, this.buildSecretTransform(index));
    }

    @Override
    public ServiceBindingSpecFluent.SecretTransformsNested<A> editFirstSecretTransform() {
        if (this.secretTransforms.size() == 0) {
            throw new RuntimeException("Can't edit first secretTransforms. The list is empty.");
        }
        return this.setNewSecretTransformLike(0, this.buildSecretTransform(0));
    }

    @Override
    public ServiceBindingSpecFluent.SecretTransformsNested<A> editLastSecretTransform() {
        int index = this.secretTransforms.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secretTransforms. The list is empty.");
        }
        return this.setNewSecretTransformLike(index, this.buildSecretTransform(index));
    }

    @Override
    public ServiceBindingSpecFluent.SecretTransformsNested<A> editMatchingSecretTransform(Predicate<SecretTransformBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secretTransforms.size(); ++i) {
            if (!predicate.test(this.secretTransforms.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secretTransforms. No match found.");
        }
        return this.setNewSecretTransformLike(index, this.buildSecretTransform(index));
    }

    @Override
    @Deprecated
    public UserInfo getUserInfo() {
        return this.userInfo != null ? this.userInfo.build() : null;
    }

    @Override
    public UserInfo buildUserInfo() {
        return this.userInfo != null ? this.userInfo.build() : null;
    }

    @Override
    public A withUserInfo(UserInfo userInfo) {
        this._visitables.get((Object)"userInfo").remove(this.userInfo);
        if (userInfo != null) {
            this.userInfo = new UserInfoBuilder(userInfo);
            this._visitables.get((Object)"userInfo").add(this.userInfo);
        } else {
            this.userInfo = null;
            this._visitables.get((Object)"userInfo").remove(this.userInfo);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUserInfo() {
        return this.userInfo != null;
    }

    @Override
    public ServiceBindingSpecFluent.UserInfoNested<A> withNewUserInfo() {
        return new UserInfoNestedImpl();
    }

    @Override
    public ServiceBindingSpecFluent.UserInfoNested<A> withNewUserInfoLike(UserInfo item) {
        return new UserInfoNestedImpl(item);
    }

    @Override
    public ServiceBindingSpecFluent.UserInfoNested<A> editUserInfo() {
        return this.withNewUserInfoLike(this.getUserInfo());
    }

    @Override
    public ServiceBindingSpecFluent.UserInfoNested<A> editOrNewUserInfo() {
        return this.withNewUserInfoLike(this.getUserInfo() != null ? this.getUserInfo() : new UserInfoBuilder().build());
    }

    @Override
    public ServiceBindingSpecFluent.UserInfoNested<A> editOrNewUserInfoLike(UserInfo item) {
        return this.withNewUserInfoLike(this.getUserInfo() != null ? this.getUserInfo() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingSpecFluentImpl that = (ServiceBindingSpecFluentImpl)o;
        if (!Objects.equals(this.externalID, that.externalID)) {
            return false;
        }
        if (!Objects.equals(this.instanceRef, that.instanceRef)) {
            return false;
        }
        if (!Objects.equals(this.parameters, that.parameters)) {
            return false;
        }
        if (!Objects.equals(this.parametersFrom, that.parametersFrom)) {
            return false;
        }
        if (!Objects.equals(this.secretName, that.secretName)) {
            return false;
        }
        if (!Objects.equals(this.secretTransforms, that.secretTransforms)) {
            return false;
        }
        return Objects.equals(this.userInfo, that.userInfo);
    }

    public int hashCode() {
        return Objects.hash(this.externalID, this.instanceRef, this.parameters, this.parametersFrom, this.secretName, this.secretTransforms, this.userInfo, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.externalID != null) {
            sb.append("externalID:");
            sb.append(this.externalID + ",");
        }
        if (this.instanceRef != null) {
            sb.append("instanceRef:");
            sb.append(this.instanceRef + ",");
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("parameters:");
            sb.append(this.parameters + ",");
        }
        if (this.parametersFrom != null) {
            sb.append("parametersFrom:");
            sb.append(this.parametersFrom + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.secretTransforms != null) {
            sb.append("secretTransforms:");
            sb.append(this.secretTransforms + ",");
        }
        if (this.userInfo != null) {
            sb.append("userInfo:");
            sb.append(this.userInfo);
        }
        sb.append("}");
        return sb.toString();
    }

    class UserInfoNestedImpl<N>
    extends UserInfoFluentImpl<ServiceBindingSpecFluent.UserInfoNested<N>>
    implements ServiceBindingSpecFluent.UserInfoNested<N>,
    Nested<N> {
        UserInfoBuilder builder;

        UserInfoNestedImpl(UserInfo item) {
            this.builder = new UserInfoBuilder(this, item);
        }

        UserInfoNestedImpl() {
            this.builder = new UserInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingSpecFluentImpl.this.withUserInfo(this.builder.build());
        }

        @Override
        public N endUserInfo() {
            return this.and();
        }
    }

    class SecretTransformsNestedImpl<N>
    extends SecretTransformFluentImpl<ServiceBindingSpecFluent.SecretTransformsNested<N>>
    implements ServiceBindingSpecFluent.SecretTransformsNested<N>,
    Nested<N> {
        SecretTransformBuilder builder;
        int index;

        SecretTransformsNestedImpl(int index, SecretTransform item) {
            this.index = index;
            this.builder = new SecretTransformBuilder(this, item);
        }

        SecretTransformsNestedImpl() {
            this.index = -1;
            this.builder = new SecretTransformBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingSpecFluentImpl.this.setToSecretTransforms(this.index, this.builder.build());
        }

        @Override
        public N endSecretTransform() {
            return this.and();
        }
    }

    class ParametersFromNestedImpl<N>
    extends ParametersFromSourceFluentImpl<ServiceBindingSpecFluent.ParametersFromNested<N>>
    implements ServiceBindingSpecFluent.ParametersFromNested<N>,
    Nested<N> {
        ParametersFromSourceBuilder builder;
        int index;

        ParametersFromNestedImpl(int index, ParametersFromSource item) {
            this.index = index;
            this.builder = new ParametersFromSourceBuilder(this, item);
        }

        ParametersFromNestedImpl() {
            this.index = -1;
            this.builder = new ParametersFromSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingSpecFluentImpl.this.setToParametersFrom(this.index, this.builder.build());
        }

        @Override
        public N endParametersFrom() {
            return this.and();
        }
    }

    class InstanceRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ServiceBindingSpecFluent.InstanceRefNested<N>>
    implements ServiceBindingSpecFluent.InstanceRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        InstanceRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        InstanceRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingSpecFluentImpl.this.withInstanceRef(this.builder.build());
        }

        @Override
        public N endInstanceRef() {
            return this.and();
        }
    }
}

